/*
 * Decompiled with CFR 0.152.
 */
package com.rits.cloning;

import com.rits.cloning.CloningException;
import com.rits.cloning.FastClonerArrayList;
import com.rits.cloning.FastClonerArrayListSubList;
import com.rits.cloning.FastClonerCalendar;
import com.rits.cloning.FastClonerConcurrentHashMap;
import com.rits.cloning.FastClonerConcurrentLinkedQueue;
import com.rits.cloning.FastClonerHashMap;
import com.rits.cloning.FastClonerHashSet;
import com.rits.cloning.FastClonerLinkedHashMap;
import com.rits.cloning.FastClonerLinkedList;
import com.rits.cloning.FastClonerTreeMap;
import com.rits.cloning.FastClonerTreeSet;
import com.rits.cloning.ICloningStrategy;
import com.rits.cloning.IDeepCloner;
import com.rits.cloning.IDumpCloned;
import com.rits.cloning.IFastCloner;
import com.rits.cloning.IFreezable;
import com.rits.cloning.IInstantiationStrategy;
import com.rits.cloning.Immutable;
import com.rits.cloning.ObjenesisInstantiationStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import org.objenesis.instantiator.ObjectInstantiator;

public class Cloner {
    private final IInstantiationStrategy instantiationStrategy;
    private final Set<Class<?>> ignored = new HashSet();
    private final Set<Class<?>> ignoredInstanceOf = new HashSet();
    private final Set<Class<?>> nullInstead = new HashSet();
    private final Set<Class<? extends Annotation>> nullInsteadFieldAnnotations = new HashSet<Class<? extends Annotation>>();
    private final Map<Class<?>, IFastCloner> fastCloners = new HashMap();
    private final ConcurrentHashMap<Class<?>, List<Field>> fieldsCache = new ConcurrentHashMap();
    private List<ICloningStrategy> cloningStrategies;
    private Map<Object, Object> ignoredInstances;
    private IDumpCloned dumpCloned = null;
    private boolean cloningEnabled = true;
    private boolean nullTransient = false;
    private boolean cloneSynthetics = true;
    private IDeepCloner deepCloner = new IDeepCloner(){

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            return Cloner.this.cloneInternal(o, clones);
        }
    };
    private final ConcurrentHashMap<Class<?>, Boolean> immutables = new ConcurrentHashMap();
    private boolean cloneAnonymousParent = true;
    private Map<Class, IDeepCloner> cloners = new ConcurrentHashMap<Class, IDeepCloner>();
    private static IDeepCloner IGNORE_CLONER = new IgnoreClassCloner();
    private static IDeepCloner NULL_CLONER = new NullClassCloner();
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];

    public IDumpCloned getDumpCloned() {
        return this.dumpCloned;
    }

    public void setDumpCloned(IDumpCloned dumpCloned) {
        this.dumpCloned = dumpCloned;
    }

    public Cloner() {
        this.instantiationStrategy = ObjenesisInstantiationStrategy.getInstance();
        this.init();
    }

    public Cloner(IInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
        this.init();
    }

    public boolean isNullTransient() {
        return this.nullTransient;
    }

    public void setNullTransient(boolean nullTransient) {
        this.nullTransient = nullTransient;
    }

    public void setCloneSynthetics(boolean cloneSynthetics) {
        this.cloneSynthetics = cloneSynthetics;
    }

    private void init() {
        this.registerKnownJdkImmutableClasses();
        this.registerKnownConstants();
        this.registerFastCloners();
    }

    protected void registerFastCloners() {
        this.fastCloners.put(GregorianCalendar.class, new FastClonerCalendar());
        this.fastCloners.put(ArrayList.class, new FastClonerArrayList());
        this.fastCloners.put(LinkedList.class, new FastClonerLinkedList());
        this.fastCloners.put(HashSet.class, new FastClonerHashSet());
        this.fastCloners.put(HashMap.class, new FastClonerHashMap());
        this.fastCloners.put(TreeMap.class, new FastClonerTreeMap());
        this.fastCloners.put(TreeSet.class, new FastClonerTreeSet());
        this.fastCloners.put(LinkedHashMap.class, new FastClonerLinkedHashMap());
        this.fastCloners.put(ConcurrentHashMap.class, new FastClonerConcurrentHashMap());
        this.fastCloners.put(ConcurrentLinkedQueue.class, new FastClonerConcurrentLinkedQueue());
        FastClonerArrayListSubList subListCloner = new FastClonerArrayListSubList();
        this.registerInaccessibleClassToBeFastCloned("java.util.AbstractList$SubList", subListCloner);
        this.registerInaccessibleClassToBeFastCloned("java.util.ArrayList$SubList", subListCloner);
        this.registerInaccessibleClassToBeFastCloned("java.util.SubList", subListCloner);
        this.registerInaccessibleClassToBeFastCloned("java.util.RandomAccessSubList", subListCloner);
    }

    protected void registerInaccessibleClassToBeFastCloned(String className, IFastCloner fastCloner) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> subListClz = classLoader.loadClass(className);
            this.fastCloners.put(subListClz, fastCloner);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected Object fastClone(Object o, Map<Object, Object> clones) {
        Class<?> c = o.getClass();
        IFastCloner fastCloner = this.fastCloners.get(c);
        if (fastCloner != null) {
            return fastCloner.clone(o, this.deepCloner, clones);
        }
        return null;
    }

    public void registerConstant(Object o) {
        if (this.ignoredInstances == null) {
            this.ignoredInstances = new IdentityHashMap<Object, Object>();
        }
        this.ignoredInstances.put(o, o);
    }

    public void registerConstant(Class<?> c, String privateFieldName) {
        try {
            List<Field> fields = this.allFields(c);
            for (Field field : fields) {
                if (!field.getName().equals(privateFieldName)) continue;
                field.setAccessible(true);
                Object v = field.get(null);
                this.registerConstant(v);
                return;
            }
            throw new CloningException("No such field : " + privateFieldName);
        }
        catch (SecurityException e) {
            throw new CloningException(e);
        }
        catch (IllegalArgumentException e) {
            throw new CloningException(e);
        }
        catch (IllegalAccessException e) {
            throw new CloningException(e);
        }
    }

    protected void registerKnownJdkImmutableClasses() {
        this.registerImmutable(String.class);
        this.registerImmutable(Integer.class);
        this.registerImmutable(Long.class);
        this.registerImmutable(Boolean.class);
        this.registerImmutable(Class.class);
        this.registerImmutable(Float.class);
        this.registerImmutable(Double.class);
        this.registerImmutable(Character.class);
        this.registerImmutable(Byte.class);
        this.registerImmutable(Short.class);
        this.registerImmutable(Void.class);
        this.registerImmutable(BigDecimal.class);
        this.registerImmutable(BigInteger.class);
        this.registerImmutable(URI.class);
        this.registerImmutable(URL.class);
        this.registerImmutable(UUID.class);
        this.registerImmutable(Pattern.class);
    }

    protected void registerKnownConstants() {
    }

    public void registerCloningStrategy(ICloningStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy can't be null");
        }
        if (this.cloningStrategies == null) {
            this.cloningStrategies = new ArrayList<ICloningStrategy>();
        }
        this.cloningStrategies.add(strategy);
    }

    public void registerStaticFields(Class<?> ... classes) {
        for (Class<?> c : classes) {
            List<Field> fields = this.allFields(c);
            for (Field field : fields) {
                int mods = field.getModifiers();
                if (!Modifier.isStatic(mods) || field.getType().isPrimitive()) continue;
                this.registerConstant(c, field.getName());
            }
        }
    }

    public void setExtraStaticFields(Set<Class<?>> set) {
        this.registerStaticFields((Class[])set.toArray());
    }

    public void dontClone(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignored.add(cl);
        }
    }

    public void dontCloneInstanceOf(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignoredInstanceOf.add(cl);
        }
    }

    public void setDontCloneInstanceOf(Class<?> ... c) {
        this.dontCloneInstanceOf(c);
    }

    public void nullInsteadOfClone(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.nullInstead.add(cl);
        }
    }

    public void setExtraNullInsteadOfClone(Set<Class<?>> set) {
        this.nullInstead.addAll(set);
    }

    @SafeVarargs
    public final void nullInsteadOfCloneFieldAnnotation(Class<? extends Annotation> ... a) {
        for (Class<? extends Annotation> an : a) {
            this.nullInsteadFieldAnnotations.add(an);
        }
    }

    public void setExtraNullInsteadOfCloneFieldAnnotation(Set<Class<? extends Annotation>> set) {
        this.nullInsteadFieldAnnotations.addAll(set);
    }

    public void registerImmutable(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignored.add(cl);
        }
    }

    public void setExtraImmutables(Set<Class<?>> set) {
        this.ignored.addAll(set);
    }

    public void registerFastCloner(Class<?> c, IFastCloner fastCloner) {
        if (this.fastCloners.containsKey(c)) {
            throw new IllegalArgumentException(c + " already fast-cloned!");
        }
        this.fastCloners.put(c, fastCloner);
    }

    public void unregisterFastCloner(Class<?> c) {
        this.fastCloners.remove(c);
    }

    protected <T> T newInstance(Class<T> c) {
        return this.instantiationStrategy.newInstance(c);
    }

    public <T> T fastCloneOrNewInstance(Class<T> c) {
        Object fastClone = this.fastClone(c, null);
        if (fastClone != null) {
            return (T)fastClone;
        }
        return this.newInstance(c);
    }

    public <T> T deepClone(T o) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(o.getClass());
        }
        ClonesMap clones = new ClonesMap();
        return this.cloneInternal(o, clones);
    }

    public <T> T deepCloneDontCloneInstances(T o, Object ... dontCloneThese) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(o.getClass());
        }
        ClonesMap clones = new ClonesMap();
        for (Object dc : dontCloneThese) {
            clones.put(dc, dc);
        }
        return this.cloneInternal(o, clones);
    }

    public <T> T shallowClone(T o) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        return this.cloneInternal(o, null);
    }

    protected boolean considerImmutable(Class<?> clz) {
        return false;
    }

    protected Class<?> getImmutableAnnotation() {
        return Immutable.class;
    }

    private boolean isImmutable(Class<?> clz) {
        Boolean isIm = this.immutables.get(clz);
        if (isIm != null) {
            return isIm;
        }
        if (this.considerImmutable(clz)) {
            return true;
        }
        Class<?> immutableAnnotation = this.getImmutableAnnotation();
        for (Annotation annotation : clz.getDeclaredAnnotations()) {
            if (annotation.annotationType() != immutableAnnotation) continue;
            this.immutables.put(clz, Boolean.TRUE);
            return true;
        }
        for (Class<?> c = clz.getSuperclass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Annotation annotation : c.getDeclaredAnnotations()) {
                Immutable im;
                if (annotation.annotationType() != Immutable.class || !(im = (Immutable)annotation).subClass()) continue;
                this.immutables.put(clz, Boolean.TRUE);
                return true;
            }
        }
        this.immutables.put(clz, Boolean.FALSE);
        return false;
    }

    protected <T> T cloneInternal(T o, Map<Object, Object> clones) {
        Object clone;
        if (o == null) {
            return null;
        }
        if (o == this) {
            return null;
        }
        if (clones != null && (clone = clones.get(o)) != null) {
            return (T)clone;
        }
        Class<?> aClass = o.getClass();
        IDeepCloner cloner = this.cloners.get(aClass);
        if (cloner == null) {
            cloner = this.findDeepCloner(aClass);
            this.cloners.put(aClass, cloner);
        }
        if (cloner == IGNORE_CLONER) {
            return o;
        }
        if (cloner == NULL_CLONER) {
            return null;
        }
        return cloner.deepClone(o, clones);
    }

    private IDeepCloner findDeepCloner(Class<?> clz) {
        if (Enum.class.isAssignableFrom(clz)) {
            return IGNORE_CLONER;
        }
        if (IFreezable.class.isAssignableFrom(clz)) {
            return new IFreezableCloner(clz);
        }
        if (this.nullInstead.contains(clz)) {
            return NULL_CLONER;
        }
        if (this.ignored.contains(clz)) {
            return IGNORE_CLONER;
        }
        if (this.isImmutable(clz)) {
            return IGNORE_CLONER;
        }
        if (clz.isArray()) {
            return new CloneArrayCloner(clz);
        }
        IFastCloner fastCloner = this.fastCloners.get(clz);
        if (fastCloner != null) {
            return new FastClonerCloner(fastCloner);
        }
        for (Class<?> iClz : this.ignoredInstanceOf) {
            if (!iClz.isAssignableFrom(clz)) continue;
            return IGNORE_CLONER;
        }
        return new CloneObjectCloner(clz);
    }

    private Object applyCloningStrategy(Map<Object, Object> clones, Object o, Object fieldObject, Field field) {
        if (this.cloningStrategies != null) {
            for (ICloningStrategy strategy : this.cloningStrategies) {
                ICloningStrategy.Strategy s = strategy.strategyFor(o, field);
                if (s == ICloningStrategy.Strategy.NULL_INSTEAD_OF_CLONE) {
                    return null;
                }
                if (s != ICloningStrategy.Strategy.SAME_INSTANCE_INSTEAD_OF_CLONE) continue;
                return fieldObject;
            }
        }
        return this.cloneInternal(fieldObject, clones);
    }

    private boolean isAnonymousParent(Field field) {
        return "this$0".equals(field.getName());
    }

    public <T, E extends T> void copyPropertiesOfInheritedClass(T src, E dest) {
        if (src == null) {
            throw new IllegalArgumentException("src can't be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("dest can't be null");
        }
        Class<?> srcClz = src.getClass();
        Class<?> destClz = dest.getClass();
        if (srcClz.isArray()) {
            if (!destClz.isArray()) {
                throw new IllegalArgumentException("can't copy from array to non-array class " + destClz);
            }
            int length = Array.getLength(src);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(src, i);
                Array.set(dest, i, v);
            }
            return;
        }
        List<Field> fields = this.allFields(srcClz);
        List<Field> destFields = this.allFields(dest.getClass());
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object fieldObject = field.get(src);
                field.setAccessible(true);
                if (!destFields.contains(field)) continue;
                field.set(dest, fieldObject);
            }
            catch (IllegalArgumentException e) {
                throw new CloningException(e);
            }
            catch (IllegalAccessException e) {
                throw new CloningException(e);
            }
        }
    }

    private void addAll(List<Field> l, Field[] fields) {
        for (Field field : fields) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            l.add(field);
        }
    }

    protected List<Field> allFields(Class<?> c) {
        List<Field> l = this.fieldsCache.get(c);
        if (l == null) {
            l = new LinkedList<Field>();
            Field[] fields = c.getDeclaredFields();
            this.addAll(l, fields);
            Class<?> sc = c;
            while ((sc = sc.getSuperclass()) != Object.class && sc != null) {
                this.addAll(l, sc.getDeclaredFields());
            }
            this.fieldsCache.putIfAbsent(c, l);
        }
        return l;
    }

    public boolean isDumpClonedClasses() {
        return this.dumpCloned != null;
    }

    public void setDumpClonedClasses(boolean dumpClonedClasses) {
        this.dumpCloned = dumpClonedClasses ? new IDumpCloned(){

            @Override
            public void startCloning(Class<?> clz) {
                System.out.println("clone>" + clz);
            }

            @Override
            public void cloning(Field field, Class<?> clz) {
                System.out.println("cloned field>" + field + "  -- of class " + clz);
            }
        } : null;
    }

    public boolean isCloningEnabled() {
        return this.cloningEnabled;
    }

    public void setCloningEnabled(boolean cloningEnabled) {
        this.cloningEnabled = cloningEnabled;
    }

    public void setCloneAnonymousParent(boolean cloneAnonymousParent) {
        this.cloneAnonymousParent = cloneAnonymousParent;
    }

    public boolean isCloneAnonymousParent() {
        return this.cloneAnonymousParent;
    }

    public static Cloner standard() {
        return new Cloner();
    }

    public static Cloner shared() {
        return new Cloner(new ObjenesisInstantiationStrategy());
    }

    private class ClonesMap
    extends IdentityHashMap<Object, Object> {
        private ClonesMap() {
        }

        @Override
        public Object get(Object key) {
            Object o;
            if (Cloner.this.ignoredInstances != null && (o = Cloner.this.ignoredInstances.get(key)) != null) {
                return o;
            }
            return super.get(key);
        }
    }

    private class CloneObjectCloner
    implements IDeepCloner {
        private final Field[] fields;
        private final boolean[] shouldClone;
        private final int numFields;
        private final ObjectInstantiator<?> instantiator;

        CloneObjectCloner(Class<?> clz) {
            ArrayList<Field> l = new ArrayList<Field>();
            ArrayList<Boolean> shouldCloneList = new ArrayList<Boolean>();
            Class<?> sc = clz;
            do {
                Field[] fs;
                for (Field f : fs = sc.getDeclaredFields()) {
                    int modifiers;
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if (Modifier.isStatic(modifiers = f.getModifiers()) || Cloner.this.nullTransient && Modifier.isTransient(modifiers) || this.isFieldNullInsteadBecauseOfAnnotation(f)) continue;
                    l.add(f);
                    boolean shouldClone = !(!Cloner.this.cloneSynthetics && f.isSynthetic() || !Cloner.this.cloneAnonymousParent && Cloner.this.isAnonymousParent(f));
                    shouldCloneList.add(shouldClone);
                }
            } while ((sc = sc.getSuperclass()) != Object.class && sc != null);
            this.fields = l.toArray(EMPTY_FIELD_ARRAY);
            this.numFields = this.fields.length;
            this.shouldClone = new boolean[this.numFields];
            for (int i = 0; i < shouldCloneList.size(); ++i) {
                this.shouldClone[i] = (Boolean)shouldCloneList.get(i);
            }
            this.instantiator = Cloner.this.instantiationStrategy.getInstantiatorOf(clz);
        }

        private boolean isFieldNullInsteadBecauseOfAnnotation(Field f) {
            if (!Cloner.this.nullInsteadFieldAnnotations.isEmpty()) {
                for (Annotation annotation : f.getAnnotations()) {
                    boolean isAnnotatedWithNullInsteadAnnotation = Cloner.this.nullInsteadFieldAnnotations.contains(annotation.annotationType());
                    if (!isAnnotatedWithNullInsteadAnnotation) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            try {
                if (Cloner.this.dumpCloned != null) {
                    Cloner.this.dumpCloned.startCloning(o.getClass());
                }
                Object newInstance = this.instantiator.newInstance();
                if (clones != null) {
                    clones.put(o, newInstance);
                    for (int i = 0; i < this.numFields; ++i) {
                        Field field = this.fields[i];
                        Object fieldObject = field.get(o);
                        Object fieldObjectClone = this.shouldClone[i] ? Cloner.this.applyCloningStrategy(clones, o, fieldObject, field) : fieldObject;
                        field.set(newInstance, fieldObjectClone);
                        if (Cloner.this.dumpCloned == null || fieldObjectClone == fieldObject) continue;
                        Cloner.this.dumpCloned.cloning(field, o.getClass());
                    }
                } else {
                    for (int i = 0; i < this.numFields; ++i) {
                        Field field = this.fields[i];
                        field.set(newInstance, field.get(o));
                    }
                }
                return (T)newInstance;
            }
            catch (IllegalAccessException e) {
                throw new CloningException(e);
            }
        }
    }

    private class IFreezableCloner
    implements IDeepCloner {
        IDeepCloner cloner;

        public IFreezableCloner(Class<?> clz) {
            this.cloner = new CloneObjectCloner(clz);
        }

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            IFreezable f;
            if (o instanceof IFreezable && (f = (IFreezable)o).isFrozen()) {
                return o;
            }
            return this.cloner.deepClone(o, clones);
        }
    }

    private static class NullClassCloner
    implements IDeepCloner {
        private NullClassCloner() {
        }

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            throw new CloningException("Don't call this directly");
        }
    }

    private static class IgnoreClassCloner
    implements IDeepCloner {
        private IgnoreClassCloner() {
        }

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            throw new CloningException("Don't call this directly");
        }
    }

    private class FastClonerCloner
    implements IDeepCloner {
        private IFastCloner fastCloner;
        private IDeepCloner cloneInternal;

        FastClonerCloner(IFastCloner fastCloner) {
            this.fastCloner = fastCloner;
            this.cloneInternal = Cloner.this.deepCloner;
        }

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            Object clone = this.fastCloner.clone(o, this.cloneInternal, clones);
            if (clones != null) {
                clones.put(o, clone);
            }
            return (T)clone;
        }
    }

    private class CloneArrayCloner
    implements IDeepCloner {
        private boolean primitive;
        private boolean immutable;
        private Class<?> componentType;

        CloneArrayCloner(Class<?> clz) {
            this.primitive = clz.getComponentType().isPrimitive();
            this.immutable = Cloner.this.isImmutable(clz.getComponentType());
            this.componentType = clz.getComponentType();
        }

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            if (Cloner.this.dumpCloned != null) {
                Cloner.this.dumpCloned.startCloning(o.getClass());
            }
            int length = Array.getLength(o);
            Object newInstance = Array.newInstance(this.componentType, length);
            if (clones != null) {
                clones.put(o, newInstance);
            }
            if (this.primitive || this.immutable) {
                System.arraycopy(o, 0, newInstance, 0, length);
            } else if (clones == null) {
                for (int i = 0; i < length; ++i) {
                    Array.set(newInstance, i, Array.get(o, i));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    Array.set(newInstance, i, Cloner.this.cloneInternal(Array.get(o, i), clones));
                }
            }
            return (T)newInstance;
        }
    }
}

