/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

public interface Bits {
    public static final Bits ALL = new MatchAllBits();
    public static final Bits NONE = new MatchNoBits();

    public boolean get(int var1);

    public int length();

    public static Bits inverseOf(final Bits bits) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                return !bits.get(index);
            }

            @Override
            public int length() {
                return bits.length();
            }
        };
    }

    public static Bits intersectionOf(final Bits a, final Bits b) {
        if (a instanceof MatchAllBits) {
            return b;
        }
        if (b instanceof MatchAllBits) {
            return a;
        }
        if (a instanceof MatchNoBits) {
            return a;
        }
        if (b instanceof MatchNoBits) {
            return b;
        }
        return new Bits(){

            @Override
            public boolean get(int index) {
                return a.get(index) && b.get(index);
            }

            @Override
            public int length() {
                return Math.max(a.length(), b.length());
            }
        };
    }

    public static class MatchAllBits
    implements Bits {
        final int len;

        public MatchAllBits() {
            this(-1);
        }

        public MatchAllBits(int len) {
            this.len = len;
        }

        @Override
        public boolean get(int index) {
            return true;
        }

        @Override
        public int length() {
            if (this.len == -1) {
                throw new UnsupportedOperationException("Unspecified length");
            }
            return this.len;
        }
    }

    public static class MatchNoBits
    implements Bits {
        final int len;

        public MatchNoBits() {
            this(-1);
        }

        public MatchNoBits(int len) {
            this.len = len;
        }

        @Override
        public boolean get(int index) {
            return false;
        }

        @Override
        public int length() {
            if (this.len == -1) {
                throw new UnsupportedOperationException("Unspecified length");
            }
            return this.len;
        }
    }
}

