/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jdesktop.swingx.painter.AbstractAreaPainter;

public class MattePainter
extends AbstractAreaPainter<Component> {
    public MattePainter() {
    }

    public MattePainter(Paint paint) {
        super(paint);
    }

    public MattePainter(Paint paint, boolean paintStretched) {
        super(paint);
        this.setPaintStretched(paintStretched);
    }

    @Override
    protected void doPaint(Graphics2D g, Component component, int width, int height) {
        Paint p = this.getFillPaint();
        if (p != null) {
            Insets insets = this.getInsets();
            int w = width - insets.left - insets.right;
            int h = height - insets.top - insets.bottom;
            if (this.isPaintStretched()) {
                p = this.calculateSnappedPaint(p, w, h);
            }
            g.translate(insets.left, insets.top);
            g.setPaint(p);
            g.fill(this.provideShape(g, component, w, h));
        }
    }

    @Override
    protected Shape provideShape(Graphics2D g, Component comp, int width, int height) {
        return new Rectangle(0, 0, width, height);
    }
}

