/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.util.WeakHashMap;

public class UIUtil {
    public static double getScaleFactor() {
        return GraphicsEnvironment.isHeadless() ? 1.0 : DetectRetinaKit.getScaleFactor();
    }

    private static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Double> devicesScaleFactorCacheMap = new WeakHashMap();

        private DetectRetinaKit() {
        }

        private static double getScaleFactorModern(GraphicsDevice device) {
            GraphicsConfiguration graphicsConfig = device.getDefaultConfiguration();
            AffineTransform tx = graphicsConfig.getDefaultTransform();
            double scaleX = tx.getScaleX();
            double scaleY = tx.getScaleY();
            return Math.max(scaleX, scaleY);
        }

        private static double getScaleFactor(GraphicsDevice device) {
            if (devicesScaleFactorCacheMap.containsKey(device)) {
                return devicesScaleFactorCacheMap.get(device);
            }
            double result = DetectRetinaKit.getScaleFactorModern(device);
            devicesScaleFactorCacheMap.put(device, result);
            return result;
        }

        private static double getScaleFactor() {
            GraphicsDevice[] devices;
            double result = 1.0;
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : devices = e.getScreenDevices()) {
                result = Math.max(result, DetectRetinaKit.getScaleFactor(device));
            }
            return result;
        }
    }
}

