/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jdesktop.swingx.image.JBHiDPIScaledImage;
import org.jdesktop.swingx.image.UIUtil;

public class RadianceCC {
    public static BufferedImage getBlankScaledImage(double scale, int width, int height) {
        if (scale > 1.0) {
            return JBHiDPIScaledImage.createScaled(scale, width, height, 2);
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }

    public static void drawImageWithScale(Graphics g, double scaleFactor, Image img, int x, int y) {
        if (img instanceof JBHiDPIScaledImage) {
            g.drawImage(img, x, y, (int)((double)img.getWidth(null) / scaleFactor), (int)((double)img.getHeight(null) / scaleFactor), null);
        } else {
            g.drawImage(img, x, y, img.getWidth(null), img.getHeight(null), null);
        }
    }

    public static void drawImageWithScale(Graphics g, double scaleFactor, Image img, int x, int y, int width, int height, int offsetX, int offsetY) {
        if (img instanceof JBHiDPIScaledImage) {
            g.drawImage(img, x, y, x + width, y + height, x + (int)((double)offsetX * scaleFactor), y + (int)((double)offsetY * scaleFactor), x + (int)((double)(offsetX + width) * scaleFactor), y + (int)((double)(offsetY + height) * scaleFactor), null);
        } else {
            g.drawImage(img, x, y, x + width, y + height, x + offsetX, y + offsetY, x + offsetX + width, y + offsetY + height, null);
        }
    }

    public static double getScaleFactor(Component component) {
        if (component == null || component.getGraphicsConfiguration() == null) {
            return UIUtil.getScaleFactor();
        }
        AffineTransform transform = component.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getDefaultTransform();
        return Math.max(transform.getScaleX(), transform.getScaleY());
    }
}

