/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.jdesktop.swingx.image.HiDPIScaledGraphics;

public class JBHiDPIScaledImage
extends BufferedImage {
    private boolean ignoreScaling;
    private double scaleFactor;

    private JBHiDPIScaledImage(double scaleFactor, int width, int height, int type) {
        super(width, height, type);
        this.scaleFactor = scaleFactor;
    }

    private JBHiDPIScaledImage(double scaleFactor, ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied) {
        super(cm, raster, isRasterPremultiplied, null);
        this.scaleFactor = scaleFactor;
    }

    public static JBHiDPIScaledImage createScaled(double scaleFactor, int width, int height, int type) {
        return new JBHiDPIScaledImage(scaleFactor, (int)Math.ceil(scaleFactor * (double)width), (int)Math.ceil(scaleFactor * (double)height), type);
    }

    public static JBHiDPIScaledImage createUnscaled(int width, int height, int type) {
        JBHiDPIScaledImage result = new JBHiDPIScaledImage(1.0, width, height, type);
        result.ignoreScaling = true;
        return result;
    }

    public static JBHiDPIScaledImage create(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied) {
        return new JBHiDPIScaledImage(1.0, cm, raster, isRasterPremultiplied);
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g = super.createGraphics();
        if (!this.ignoreScaling) {
            g.scale(this.scaleFactor, this.scaleFactor);
        }
        return new HiDPIScaledGraphics(g);
    }
}

