/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.slf4;

import elf4j.Level;
import elf4j.engine.NativeLogger;
import java.util.EnumMap;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.DefaultLoggingEventBuilder;
import org.slf4j.spi.LoggingEventAware;

public class Elf4jLogger
implements Logger,
LoggingEventAware {
    private static final Class<?> LOGGING_SERVICE_CLASS_SLF4J_FLUENT_API = DefaultLoggingEventBuilder.class;
    private static final Class<?> LOGGING_SERVICE_CLASS_SLF4J_LEGACY_API = Elf4jLogger.class;
    private static final EnumMap<org.slf4j.event.Level, Level> SLF4J_EVENT_TO_ELF4J_LEVEL_MAP = new EnumMap(org.slf4j.event.Level.class);
    private final NativeLogger nativeLogger;

    public Elf4jLogger(NativeLogger nativeLogger) {
        this.nativeLogger = nativeLogger;
    }

    private static Level translate(org.slf4j.event.Level slf4jEventLevel) {
        return SLF4J_EVENT_TO_ELF4J_LEVEL_MAP.get(slf4jEventLevel);
    }

    public String getName() {
        return this.nativeLogger.getOwnerClassName();
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public void trace(String msg) {
        this.elf4jLog(Level.TRACE, null, msg, new Object[0]);
    }

    public void trace(String format, Object arg) {
        this.elf4jLog(Level.TRACE, null, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.elf4jLog(Level.TRACE, null, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.elf4jLog(Level.TRACE, null, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.elf4jLog(Level.TRACE, t, msg, new Object[0]);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public void debug(String msg) {
        this.elf4jLog(Level.DEBUG, null, msg, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.elf4jLog(Level.DEBUG, null, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.elf4jLog(Level.DEBUG, null, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.elf4jLog(Level.DEBUG, null, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.elf4jLog(Level.DEBUG, t, msg, new Object[0]);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public void info(String msg) {
        this.elf4jLog(Level.INFO, null, msg, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.elf4jLog(Level.INFO, null, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.elf4jLog(Level.INFO, null, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.elf4jLog(Level.INFO, null, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.elf4jLog(Level.INFO, t, msg, new Object[0]);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public void warn(String msg) {
        this.elf4jLog(Level.WARN, null, msg, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.elf4jLog(Level.WARN, null, format, arg);
    }

    public void warn(String format, Object ... arguments) {
        this.elf4jLog(Level.WARN, null, format, arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.elf4jLog(Level.WARN, null, format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.elf4jLog(Level.WARN, t, msg, new Object[0]);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public void error(String msg) {
        this.elf4jLog(Level.ERROR, null, msg, new Object[0]);
    }

    public void error(String format, Object arg) {
        this.elf4jLog(Level.ERROR, null, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.elf4jLog(Level.ERROR, null, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.elf4jLog(Level.ERROR, null, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.elf4jLog(Level.ERROR, t, msg, new Object[0]);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    public void log(LoggingEvent event) {
        this.service(this.nativeLogger.atLevel(Elf4jLogger.translate(event.getLevel())), LOGGING_SERVICE_CLASS_SLF4J_FLUENT_API, event.getThrowable(), event.getMessage(), event.getArgumentArray());
    }

    private void elf4jLog(Level elf4jLevel, Throwable t, String msg, Object ... args) {
        this.service(this.nativeLogger.atLevel(elf4jLevel), LOGGING_SERVICE_CLASS_SLF4J_LEGACY_API, t, msg, args);
    }

    private boolean isEnabled(Level elf4jLevel) {
        return this.nativeLogger.atLevel(elf4jLevel).isEnabled();
    }

    private void service(NativeLogger delegate, Class<?> loggingServiceInterface, Throwable t, String msg, Object ... args) {
        delegate.getLogService().log(delegate, loggingServiceInterface, t, (Object)msg, args);
    }

    static {
        SLF4J_EVENT_TO_ELF4J_LEVEL_MAP.put(org.slf4j.event.Level.TRACE, Level.TRACE);
        SLF4J_EVENT_TO_ELF4J_LEVEL_MAP.put(org.slf4j.event.Level.DEBUG, Level.DEBUG);
        SLF4J_EVENT_TO_ELF4J_LEVEL_MAP.put(org.slf4j.event.Level.INFO, Level.INFO);
        SLF4J_EVENT_TO_ELF4J_LEVEL_MAP.put(org.slf4j.event.Level.WARN, Level.WARN);
        SLF4J_EVENT_TO_ELF4J_LEVEL_MAP.put(org.slf4j.event.Level.ERROR, Level.ERROR);
    }
}

