/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.writer;

import elf4j.Level;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternGroup;
import elf4j.engine.service.util.PropertiesUtils;
import elf4j.engine.service.writer.LogWriter;
import elf4j.engine.service.writer.LogWriterType;
import elf4j.engine.service.writer.StandardOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.NonNull;

public class StandardStreamsWriter
implements LogWriter {
    private static final String DEFAULT_MINIMUM_LEVEL = "trace";
    private static final String DEFAULT_PATTERN = "{timestamp} {level} {class} - {message}";
    private static final String DEFAULT_WRITER_OUT_STREAM = "stdout";
    private static final String LINE_FEED = System.lineSeparator();
    private final Level minimumLevel;
    private final LogPattern logPattern;
    private final StandardOutput standardOutput;

    @Override
    public Level getMinimumOutputLevel() {
        return this.minimumLevel;
    }

    @Override
    public void write(@NonNull LogEvent logEvent) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (logEvent.getNativeLogger().getLevel().compareTo((Enum)this.minimumLevel) < 0) {
            return;
        }
        StringBuilder target = new StringBuilder();
        this.logPattern.render(logEvent, target);
        byte[] bytes = target.append(LINE_FEED).toString().getBytes(StandardCharsets.UTF_8);
        this.standardOutput.write(bytes);
    }

    @Override
    public boolean includeCallerDetail() {
        return this.logPattern.includeCallerDetail();
    }

    @Override
    public boolean includeCallerThread() {
        return this.logPattern.includeCallerThread();
    }

    StandardStreamsWriter(Level minimumLevel, LogPattern logPattern, StandardOutput standardOutput) {
        this.minimumLevel = minimumLevel;
        this.logPattern = logPattern;
        this.standardOutput = standardOutput;
    }

    public static StandardStreamsWriterBuilder builder() {
        return new StandardStreamsWriterBuilder();
    }

    public String toString() {
        return "StandardStreamsWriter(minimumLevel=" + this.minimumLevel + ", logPattern=" + this.logPattern + ", standardOutput=" + this.standardOutput + ")";
    }

    public static class StandardStreamsWriterBuilder {
        private Level minimumLevel;
        private LogPattern logPattern;
        private StandardOutput standardOutput;

        StandardStreamsWriterBuilder() {
        }

        public StandardStreamsWriterBuilder minimumLevel(Level minimumLevel) {
            this.minimumLevel = minimumLevel;
            return this;
        }

        public StandardStreamsWriterBuilder logPattern(LogPattern logPattern) {
            this.logPattern = logPattern;
            return this;
        }

        public StandardStreamsWriterBuilder standardOutput(StandardOutput standardOutput) {
            this.standardOutput = standardOutput;
            return this;
        }

        public StandardStreamsWriter build() {
            return new StandardStreamsWriter(this.minimumLevel, this.logPattern, this.standardOutput);
        }

        public String toString() {
            return "StandardStreamsWriter.StandardStreamsWriterBuilder(minimumLevel=" + this.minimumLevel + ", logPattern=" + this.logPattern + ", standardOutput=" + this.standardOutput + ")";
        }
    }

    public static class StandardStreamsWriterType
    implements LogWriterType {
        private static StandardStreamsWriter getDefaultWriter(LogServiceConfiguration logServiceConfiguration) {
            Properties properties = logServiceConfiguration.getProperties();
            return StandardStreamsWriter.builder().minimumLevel(Level.valueOf((String)properties.getProperty("level", StandardStreamsWriter.DEFAULT_MINIMUM_LEVEL).trim().toUpperCase())).logPattern(PatternGroup.from(properties.getProperty("pattern", StandardStreamsWriter.DEFAULT_PATTERN))).standardOutput(logServiceConfiguration.getStandardOutput()).build();
        }

        private static String getWriterConfiguredOrDefault(String name, Map<String, String> writerConfiguration, Properties properties, String defaultValue) {
            return writerConfiguration.getOrDefault(name, properties.getProperty(name, defaultValue));
        }

        @Override
        public List<LogWriter> getLogWriters(LogServiceConfiguration logServiceConfiguration) {
            ArrayList<LogWriter> standardStreamsWriters = new ArrayList<LogWriter>();
            Properties properties = logServiceConfiguration.getProperties();
            List<Map<String, String>> writerConfigurations = PropertiesUtils.getPropertiesGroupOfType("standard", logServiceConfiguration.getProperties());
            if (writerConfigurations.isEmpty()) {
                standardStreamsWriters.add(StandardStreamsWriterType.getDefaultWriter(logServiceConfiguration));
                return standardStreamsWriters;
            }
            return writerConfigurations.stream().map(writerConfiguration -> StandardStreamsWriter.builder().minimumLevel(Level.valueOf((String)StandardStreamsWriterType.getWriterConfiguredOrDefault("level", writerConfiguration, properties, StandardStreamsWriter.DEFAULT_MINIMUM_LEVEL).trim().toUpperCase())).logPattern(PatternGroup.from(StandardStreamsWriterType.getWriterConfiguredOrDefault("pattern", writerConfiguration, properties, StandardStreamsWriter.DEFAULT_PATTERN))).standardOutput(logServiceConfiguration.getStandardOutput()).build()).collect(Collectors.toList());
        }
    }
}

