/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.NoSuchElementException;
import lombok.NonNull;

public class StackTraceUtils {
    private StackTraceUtils() {
    }

    public static StackTraceElement callerOf(@NonNull Class<?> calleeClass) {
        if (calleeClass == null) {
            throw new NullPointerException("calleeClass is marked non-null but is null");
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return StackTraceUtils.getCallerFrame(calleeClass, stackTrace);
    }

    public static StackTraceElement getCallerFrame(@NonNull Class<?> calleeClass, @NonNull StackTraceElement[] stackTrace) {
        if (calleeClass == null) {
            throw new NullPointerException("calleeClass is marked non-null but is null");
        }
        if (stackTrace == null) {
            throw new NullPointerException("stackTrace is marked non-null but is null");
        }
        String calleeClassName = calleeClass.getName();
        for (int depth = 1; depth < stackTrace.length; ++depth) {
            if (!calleeClassName.equals(stackTrace[depth - 1].getClassName()) || calleeClassName.equals(stackTrace[depth].getClassName())) continue;
            return stackTrace[depth];
        }
        throw new NoSuchElementException("Caller of '" + calleeClass + "' not found in call stack");
    }

    public static StringBuffer getTraceAsBuffer(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            return stringBuffer;
        }
    }
}

