/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.util;

import elf4j.util.IeLogger;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.awaitility.Awaitility;

public class MoreAwaitility {
    private MoreAwaitility() {
    }

    public static void suspend(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        MoreAwaitility.suspend(duration, null);
    }

    public static void suspend(@NonNull Duration duration, String message) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        if (message != null) {
            IeLogger.INFO.log("{}, suspending current {} for {}", new Object[]{message, Thread.currentThread(), duration});
        }
        AtomicBoolean resume = new AtomicBoolean(false);
        ScheduledExecutorService delayer = Executors.newSingleThreadScheduledExecutor();
        delayer.schedule(() -> resume.set(true), duration.toMillis(), TimeUnit.MILLISECONDS);
        delayer.shutdown();
        Awaitility.with().pollInterval(duration.dividedBy(10L)).await().untilTrue(resume);
    }
}

