/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class VerbatimPattern
implements LogPattern {
    @NonNull
    private final String text;

    @Nonnull
    public static VerbatimPattern from(String patternSegment) {
        if (!PatternType.VERBATIM.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException(String.format("patternSegment '%s' looks to be targeted at another known patternSegment type than %s", new Object[]{patternSegment, PatternType.VERBATIM}));
        }
        return new VerbatimPattern(patternSegment);
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    @Override
    public void render(LogEvent logEvent, @NonNull StringBuilder target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        target.append(this.text);
    }

    public VerbatimPattern(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerbatimPattern)) {
            return false;
        }
        VerbatimPattern other = (VerbatimPattern)o;
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "VerbatimPattern(text=" + this.getText() + ")";
    }
}

