/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class MethodPattern
implements LogPattern {
    @Nonnull
    public static MethodPattern from(String patternSegment) {
        if (!PatternType.METHOD.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException("patternSegment: " + patternSegment);
        }
        return new MethodPattern();
    }

    @Override
    public boolean includeCallerDetail() {
        return true;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, @NonNull StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        target.append(logEvent.getCallerDetail().getMethodName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof MethodPattern;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "MethodPattern()";
    }
}

