/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.engine.service.LogEventProcessor;
import elf4j.engine.service.Stoppable;
import elf4j.engine.service.configuration.Refreshable;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;

public enum LogServiceManager {
    INSTANCE;

    private final Set<Refreshable> refreshables = new HashSet<Refreshable>();
    private final Set<Stoppable> stoppables = new HashSet<Stoppable>();
    private final ConditionFactory await = Awaitility.with().timeout(Duration.ofMinutes(10L));

    private static boolean allStopped(@NonNull Collection<Stoppable> stoppables) {
        if (stoppables == null) {
            throw new NullPointerException("stoppables is marked non-null but is null");
        }
        return stoppables.stream().allMatch(Stoppable::isStopped);
    }

    public void registerRefresh(Refreshable refreshable) {
        this.refreshables.add(refreshable);
    }

    public void registerStop(Stoppable stoppable) {
        this.stoppables.add(stoppable);
    }

    public void refreshAll() {
        this.refreshables.forEach(Refreshable::refresh);
    }

    public void refreshAll(Properties properties) {
        this.refreshables.forEach(refreshable -> refreshable.refresh(properties));
    }

    public void stopAll() {
        this.stopFrontend();
        this.stopBackend();
    }

    @NonNull
    public Thread getShutdownHookThread() {
        return new Thread(this::stopAll);
    }

    private void stopBackend() {
        List backend = this.stoppables.stream().filter(s -> !(s instanceof LogEventProcessor)).collect(Collectors.toList());
        ((Stream)backend.stream().parallel()).forEach(Stoppable::stop);
        this.await.until(() -> LogServiceManager.allStopped(backend));
    }

    private void stopFrontend() {
        List frontend = this.stoppables.stream().filter(LogEventProcessor.class::isInstance).collect(Collectors.toList());
        ((Stream)frontend.stream().parallel()).forEach(Stoppable::stop);
        this.await.until(() -> LogServiceManager.allStopped(frontend));
    }
}

