/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import conseq4j.execute.ConseqExecutor;
import conseq4j.execute.SequentialExecutor;
import conseq4j.util.MoreRejectedExecutionHandlers;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.LogEventProcessor;
import elf4j.engine.service.LogServiceManager;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.util.PropertiesUtils;
import elf4j.engine.service.writer.LogWriter;
import elf4j.util.IeLogger;
import java.util.Properties;
import lombok.NonNull;

public class ConseqLogEventProcessor
implements LogEventProcessor {
    private static final int DEFAULT_FRONT_BUFFER_CAPACITY = Integer.MAX_VALUE;
    private static final int DEFAULT_CONCURRENCY = Runtime.getRuntime().availableProcessors();
    private final LogWriter logWriter;
    private final SequentialExecutor conseqExecutor;

    private ConseqLogEventProcessor(LogWriter logWriter, SequentialExecutor conseqExecutor) {
        this.logWriter = logWriter;
        this.conseqExecutor = conseqExecutor;
        LogServiceManager.INSTANCE.registerStop(this);
    }

    @NonNull
    public static ConseqLogEventProcessor from(@NonNull LogServiceConfiguration logServiceConfiguration) {
        if (logServiceConfiguration == null) {
            throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
        }
        Properties properties = logServiceConfiguration.getProperties();
        int workQueueCapacity = ConseqLogEventProcessor.getWorkQueueCapacity(properties);
        IeLogger.INFO.log("Buffer front: {}", new Object[]{workQueueCapacity});
        int concurrency = ConseqLogEventProcessor.getConcurrency(properties);
        IeLogger.INFO.log("Concurrency: {}", new Object[]{concurrency});
        ConseqExecutor conseqExecutor = new ConseqExecutor.Builder().concurrency(concurrency).rejectedExecutionHandler(MoreRejectedExecutionHandlers.blockingRetryPolicy()).workQueueCapacity(workQueueCapacity).build();
        return new ConseqLogEventProcessor(logServiceConfiguration.getLogServiceWriter(), (SequentialExecutor)conseqExecutor);
    }

    private static int getConcurrency(Properties properties) {
        int concurrency = PropertiesUtils.getIntOrDefault("concurrency", properties, DEFAULT_CONCURRENCY);
        if (concurrency < 1) {
            IeLogger.ERROR.log("Unexpected concurrency: {}, cannot be less than 1", new Object[]{concurrency});
            throw new IllegalArgumentException("concurrency: " + concurrency);
        }
        return concurrency;
    }

    private static int getWorkQueueCapacity(Properties properties) {
        int workQueueCapacity = PropertiesUtils.getIntOrDefault("buffer.front", properties, Integer.MAX_VALUE);
        if (workQueueCapacity < 1) {
            IeLogger.ERROR.log("Unexpected buffer.front: {}, cannot be less than 1", new Object[]{workQueueCapacity});
            throw new IllegalArgumentException("buffer.front: " + workQueueCapacity);
        }
        return workQueueCapacity;
    }

    @Override
    public void process(LogEvent logEvent) {
        this.conseqExecutor.execute(() -> this.logWriter.write(logEvent), (Object)logEvent.getCallerThread().getId());
    }

    @Override
    public void stop() {
        this.conseqExecutor.shutdown();
    }

    @Override
    public boolean isStopped() {
        return this.conseqExecutor.isTerminated();
    }
}

