/*
 * Decompiled with CFR 0.152.
 */
package top.banner.lib.curl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class Options {
    public static final Options EMPTY = new Options(Collections.emptyList());
    private final List<String> options;

    private Options(Collection<String> options) {
        this.options = new ArrayList<String>(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> list() {
        return this.options;
    }

    public static class Builder {
        private final Set<String> options = new HashSet<String>();

        public Builder insecure() {
            this.options.add("--insecure");
            return this;
        }

        public Builder maxTime(int seconds) {
            this.options.add(String.format(Locale.getDefault(), "--max-time %d", seconds));
            return this;
        }

        public Builder connectTimeout(int seconds) {
            this.options.add(String.format(Locale.getDefault(), "--connect-timeout %d", seconds));
            return this;
        }

        public Builder retry(int num) {
            this.options.add(String.format(Locale.getDefault(), "--retry %d", num));
            return this;
        }

        public Builder compressed() {
            this.options.add("--compressed");
            return this;
        }

        public Builder location() {
            this.options.add("--location");
            return this;
        }

        public Options build() {
            return new Options(this.options);
        }
    }
}

