/*
 * Decompiled with CFR 0.152.
 */
package top.banner.lib.curl;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.banner.lib.curl.CurlBuilder;
import top.banner.lib.curl.CurlRequestWrapper;
import top.banner.lib.curl.Options;
import top.banner.lib.curl.UrlPattern;

public class CurlFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CurlFilter.class);
    private final Set<String> urlPatterns = new LinkedHashSet<String>();

    public void init(FilterConfig filterConfig) {
    }

    public void addIgnoreUrlPatterns(String ... urlPatterns) {
        if (null != urlPatterns) {
            Collections.addAll(this.urlPatterns, urlPatterns);
            for (String urlPattern : urlPatterns) {
                UrlPattern.addUrlPattern(urlPattern);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.ignore(req).booleanValue()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else {
            String contentType = req.getContentType();
            if (contentType != null && contentType.toLowerCase().startsWith("multipart/")) {
                log.info("curl \u6682\u4e0d\u652f\u6301 \u8868\u5355\u4e2d\u8fdb\u884c\u6587\u4ef6\u4e0a\u4f20");
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            } else {
                CurlRequestWrapper wrapper = new CurlRequestWrapper(req);
                CurlBuilder curl = new CurlBuilder((ServletRequest)wrapper, wrapper.getBodyStr(), Options.EMPTY);
                log.info(curl.toString());
                chain.doFilter((ServletRequest)wrapper, (ServletResponse)resp);
            }
        }
    }

    private Boolean ignore(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        return UrlPattern.matches(requestURI);
    }

    public void destroy() {
    }
}

