/*
 * Decompiled with CFR 0.152.
 */
package top.banner.lib.curl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import top.banner.lib.curl.Header;
import top.banner.lib.curl.Options;
import top.banner.lib.curl.Query;

public class CurlBuilder {
    protected static final String FORMAT_HEADER = "-H '%1$s:%2$s'";
    protected static final String FORMAT_METHOD = "-X %1$s";
    protected static final String FORMAT_BODY = "-d '%1$s'";
    protected static final String FORMAT_URL = "'%1$s'";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected final String method;
    protected final String contentType;
    protected final String body;
    protected final List<String> options;
    protected final List<Header> headers;
    protected final List<Query> queries;
    private final List<String> ignoreHeaders = Arrays.asList("content-length", "sec-ch-ua", "sec-ch-ua-mobile", "sec-fetch-site", "sec-fetch-mode", "sec-fetch-dest");
    protected StringBuffer url;

    public CurlBuilder(ServletRequest servletRequest, String body, Options options) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        this.url = new StringBuffer(request.getRequestURL().toString());
        this.method = request.getMethod();
        this.options = Collections.unmodifiableList(options.list());
        List<Header> headers = this.headers(request);
        this.headers = Collections.unmodifiableList(headers);
        this.contentType = request.getContentType();
        this.body = body;
        this.queries = this.queries(request);
    }

    private static String join(CharSequence delimiter, Iterable<?> tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private List<Header> headers(HttpServletRequest request) {
        ArrayList<Header> list = new ArrayList<Header>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (this.ignoreHeaders.contains(name.toLowerCase())) continue;
            String value = request.getHeader(name);
            list.add(new Header(name, value));
        }
        return list;
    }

    private List<Query> queries(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        ArrayList<Query> list = new ArrayList<Query>();
        parameterMap.forEach((k, v) -> {
            String value = Arrays.stream(v).findFirst().orElse(null);
            list.add(new Query((String)k, value));
        });
        return list;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("curl");
        parts.addAll(this.options);
        parts.add(String.format(FORMAT_METHOD, this.method.toUpperCase()));
        for (Header header : this.headers) {
            String headerPart = String.format(FORMAT_HEADER, header.name(), header.value());
            parts.add(headerPart);
        }
        if (this.contentType != null && !this.containsName(this.headers)) {
            parts.add(String.format(FORMAT_HEADER, CONTENT_TYPE, this.contentType));
        }
        if (this.body != null) {
            parts.add(String.format(FORMAT_BODY, this.body));
        }
        if (!this.queries.isEmpty()) {
            boolean firstTime = true;
            for (Query query : this.queries) {
                if (firstTime) {
                    firstTime = false;
                    this.url.append("?");
                } else {
                    this.url.append("&");
                }
                this.url.append(query.name()).append("=").append(query.value());
            }
        }
        parts.add(String.format(FORMAT_URL, this.url.toString()));
        return CurlBuilder.join(" ", parts);
    }

    protected boolean containsName(List<Header> headers) {
        for (Header header : headers) {
            if (!Objects.equals(header.name().toLowerCase(), CONTENT_TYPE.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

