/*
 * Decompiled with CFR 0.152.
 */
package io.github.agentsoz.bushfiretute.matsim;

import io.github.agentsoz.bdimatsim.MATSimModel;
import io.github.agentsoz.bdimatsim.Replanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.mobsim.framework.HasPerson;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.ActivityEndRescheduler;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.router.TripRouter;
import org.matsim.withinday.utils.EditRoutes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CustomReplanner
extends Replanner {
    final Logger logger = LoggerFactory.getLogger((String)"");

    CustomReplanner(MATSimModel model, ActivityEndRescheduler activityEndRescheduler) {
        super(model, activityEndRescheduler);
    }

    final void addNewLegAndActvityToPlan(Id<Person> agentId, Id<Link> newActivityLinkId, int pickupTime) {
        this.logger.debug("starting addNewLegAndActvityToPlan method..");
        double now = this.model.getTime();
        MobsimAgent agent = (MobsimAgent)this.model.getMobsimAgentMap().get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        int currentPlanIndex = WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent);
        this.logger.trace("number of plan elements: " + planElements.size());
        this.logger.trace("current plan index : " + currentPlanIndex);
        PlanElement currentPE = (PlanElement)planElements.get(currentPlanIndex);
        if (currentPE instanceof Activity) {
            Activity currentAct = (Activity)currentPE;
            if (currentAct.getType().equals("Wait")) {
                this.logger.debug("Wait/Current activity ending now:  {}", (Object)now);
                currentAct.setEndTime(now);
            }
            Leg newLeg = this.model.getScenario().getPopulation().getFactory().createLeg("car");
            EditRoutes.relocateFutureLegRoute((Leg)newLeg, (Id)currentAct.getLinkId(), newActivityLinkId, (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
            this.logger.debug(" added leg to plan..");
            planElements.add(currentPlanIndex + 1, newLeg);
            Activity pickupAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId("Pickup", newActivityLinkId);
            pickupAct.setMaximumDuration((double)pickupTime);
            this.logger.debug(" added {} type activity", (Object)pickupAct.getType());
            planElements.add(currentPlanIndex + 2, pickupAct);
            Activity waitAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId("Wait", newActivityLinkId);
            waitAct.setEndTime(Double.POSITIVE_INFINITY);
            this.logger.debug(" added {} type activity with INFINITY end time..", (Object)waitAct.getType());
            planElements.add(currentPlanIndex + 3, waitAct);
            this.logger.debug("reRouting the leg after wait activity");
            Leg nextLeg = (Leg)planElements.get(currentPlanIndex + 4);
            Activity nextAct = (Activity)planElements.get(currentPlanIndex + 5);
            this.logger.trace("all evac activity info : {} ", (Object)nextAct.toString());
            EditRoutes.relocateFutureLegRoute((Leg)nextLeg, newActivityLinkId, (Id)nextAct.getLinkId(), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
            this.logger.trace("number of plan elements after adding new leg : " + planElements.size());
            WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
            this.internalInterface.rescheduleActivityEnd(agent);
        }
    }

    final void addNewActivityToPlan(Id<Person> agentId, int pickupTime) {
        this.logger.debug("started addNewActivityToPlan method..");
        double now = this.model.getTime();
        MobsimAgent agent = (MobsimAgent)this.model.getMobsimAgentMap().get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        int currentPlanIndex = WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent);
        this.logger.trace("number of plan elements : " + planElements.size());
        this.logger.trace("current plan index : " + currentPlanIndex);
        PlanElement currentPE = (PlanElement)planElements.get(currentPlanIndex);
        if (!(currentPE instanceof Activity)) {
            this.logger.error("currently exceuting plan element is not an activity");
            return;
        }
        Activity currentAct = (Activity)currentPE;
        currentAct.setEndTime(now);
        Activity newAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId("PICKUP", currentAct.getLinkId());
        newAct.setMaximumDuration((double)pickupTime);
        planElements.add(currentPlanIndex + 1, newAct);
        this.logger.debug(" added a new {} activity", (Object)newAct.getType());
        Activity waitAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId("Wait", currentAct.getLinkId());
        waitAct.setEndTime(Double.POSITIVE_INFINITY);
        this.logger.debug(" added {} type activity with INFINITY end time..", (Object)waitAct.getType());
        planElements.add(currentPlanIndex + 2, waitAct);
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        this.internalInterface.rescheduleActivityEnd(agent);
    }

    final void addNewLegToPlan(Id<Person> agentId, Id<Link> newActivityLinkId, String dest) {
        this.logger.debug("agent {} | started addNewLegToPlan method..", agentId);
        double now = this.model.getTime();
        MobsimAgent agent = (MobsimAgent)this.model.getMobsimAgentMap().get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        int currentPlanIndex = WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent);
        this.logger.trace("number of plan elements : " + planElements.size());
        this.logger.trace("current plan index : " + currentPlanIndex);
        PlanElement currentPE = (PlanElement)planElements.get(currentPlanIndex);
        if (!(currentPE instanceof Activity)) {
            this.logger.error("currently exceuting plan element is not an activity");
            return;
        }
        Activity currentAct = (Activity)currentPE;
        currentAct.setEndTime(now);
        Leg newLeg = this.model.getScenario().getPopulation().getFactory().createLeg("car");
        newLeg.setDepartureTime(now);
        EditRoutes.relocateFutureLegRoute((Leg)newLeg, (Id)currentAct.getLinkId(), newActivityLinkId, (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
        planElements.add(currentPlanIndex + 1, newLeg);
        this.logger.debug(" added a new leg to current index");
        Activity newAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId(dest, newActivityLinkId);
        newAct.setEndTime(Double.POSITIVE_INFINITY);
        planElements.add(currentPlanIndex + 2, newAct);
        this.logger.debug(" added a new {} activity", (Object)newAct.getType());
        if (currentPlanIndex + 3 == planElements.size()) {
            this.logger.debug("no leg found to relocate from the added destination..");
        } else {
            this.logger.debug("reRouting the leg after the added activity..");
            Leg nextLeg = (Leg)planElements.get(currentPlanIndex + 3);
            Activity nextAct = (Activity)planElements.get(currentPlanIndex + 4);
            EditRoutes.relocateFutureLegRoute((Leg)nextLeg, newActivityLinkId, (Id)nextAct.getLinkId(), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
            this.logger.debug("addNewActivityToPlan - leg info after reroute : " + nextLeg.toString());
        }
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        this.internalInterface.rescheduleActivityEnd(agent);
    }

    final void modifyPlanForDest(Id<Person> agentId, Id<Link> newActivityLinkId, String dest) {
        this.logger.debug("started addNewLegToPlan method..");
        double now = this.model.getTime();
        MobsimAgent agent = (MobsimAgent)this.model.getMobsimAgentMap().get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        int currentPlanIndex = WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent);
        this.logger.trace("number of plan elements : " + planElements.size());
        this.logger.trace("current plan index : " + currentPlanIndex);
        PlanElement currentPE = (PlanElement)planElements.get(currentPlanIndex);
        if (!(currentPE instanceof Activity)) {
            this.logger.error("currently exceuting plan element is not an activity");
            return;
        }
        Activity currentAct = (Activity)currentPE;
        if (!currentAct.getType().equals("Wait")) {
            this.logger.debug("current activity is not the type of Wait");
            return;
        }
        this.logger.debug("set end time of the Wait activity to {}  type {} ", (Object)now);
        currentAct.setEndTime(now);
        if (dest.equals("central point")) {
            PlanElement nextPE = (PlanElement)planElements.get(currentPlanIndex + 1);
            if (nextPE instanceof Leg) {
                Leg legCP = (Leg)nextPE;
                Activity activityCP = (Activity)planElements.get(currentPlanIndex + 2);
                if (!activityCP.getType().equals("Evacuation")) {
                    this.logger.error("activity Evacuation is not the activity after the current activity, Aborting");
                    return;
                }
                EditRoutes.relocateFutureLegRoute((Leg)legCP, (Id)currentAct.getLinkId(), (Id)activityCP.getLinkId(), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
                this.logger.debug("leg after pick up activity relocated to new dest");
                WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
                this.internalInterface.rescheduleActivityEnd(agent);
                return;
            }
            this.logger.error("plan element after the last pickup activiy is not a leg, Aborting");
        }
        if (dest.equals("safe")) {
            this.logger.debug("received the destination : safe");
            int planSize = planElements.size();
            this.logger.debug("plan size before modifying the plan : {}  current plan index : {} ", (Object)planSize, (Object)currentPlanIndex);
            int count = 0;
            while (planElements.size() > planSize - 2) {
                planElements.remove(currentPlanIndex + 1);
                ++count;
            }
            this.logger.debug("total number of elements removed : {} ", (Object)count);
            this.logger.debug("plan element size after removing : {}", (Object)planElements.size());
            PlanElement beforeLastElement = (PlanElement)plan.getPlanElements().get(planElements.size() - 2);
            if (!(beforeLastElement instanceof Leg)) {
                this.logger.error("selected plan element after removing plan elements is not a leg");
                return;
            }
            Leg lastLeg = (Leg)beforeLastElement;
            Activity safeAct = (Activity)plan.getPlanElements().get(planElements.size() - 1);
            EditRoutes.relocateFutureLegRoute((Leg)lastLeg, (Id)currentAct.getLinkId(), (Id)safeAct.getLinkId(), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
            this.logger.debug("relocated the last leg to safe dest");
            WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
            this.internalInterface.rescheduleActivityEnd(agent);
            return;
        }
        if (dest.equals("home")) {
            this.logger.debug("destination home received");
            Activity homeAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId("Home", newActivityLinkId);
            Leg homeLeg = this.model.getScenario().getPopulation().getFactory().createLeg("car");
            homeLeg.setDepartureTime(now);
            EditRoutes.relocateFutureLegRoute((Leg)homeLeg, (Id)currentAct.getLinkId(), newActivityLinkId, (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
            double homeTime = now + 7200.0 + 1000.0;
            homeAct.setEndTime(homeTime);
            homeAct.setMaximumDuration(homeTime);
            planElements.add(currentPlanIndex + 1, homeLeg);
            planElements.add(currentPlanIndex + 2, homeAct);
            this.logger.debug(" finished adding home leg and activity");
            PlanElement nextPE = (PlanElement)planElements.get(currentPlanIndex + 3);
            if (nextPE instanceof Leg) {
                Leg legCP = (Leg)nextPE;
                Activity activityCP = (Activity)planElements.get(currentPlanIndex + 4);
                if (!activityCP.getType().equals("Evacuation")) {
                    this.logger.error("activity Evacuation is not found when adding destination home, Aborting");
                    return;
                }
                EditRoutes.relocateFutureLegRoute((Leg)legCP, (Id)homeAct.getLinkId(), (Id)activityCP.getLinkId(), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
                this.logger.debug(" finished reRouting leg from home to cenrtal point");
                WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
                this.internalInterface.rescheduleActivityEnd(agent);
                return;
            }
        }
    }

    protected final void reRouteCurrentLeg(MobsimAgent agent, double time) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        PlanElement pe = (PlanElement)plan.getPlanElements().get(WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent));
        if (!(pe instanceof Leg)) {
            return;
        }
        int currentLinkIndex = WithinDayAgentUtils.getCurrentRouteLinkIdIndex((MobsimAgent)agent);
        EditRoutes.replanCurrentLegRoute((Leg)((Leg)pe), (Person)((HasPerson)agent).getPerson(), (int)currentLinkIndex, (double)time, (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
    }

    protected final void attachNewActivityAtEndOfPlan(Id<Link> newActivityLinkId, Id<Person> agentId) {
        int planElementsIndex;
        MobsimAgent agent;
        Plan plan;
        List planElements;
        Activity lastAct;
        double now = this.model.getTime();
        double endTime = now;
        if (endTime <= (lastAct = (Activity)(planElements = (plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)(agent = (MobsimAgent)this.model.getMobsimAgentMap().get(agentId)))).getPlanElements()).get(planElementsIndex = planElements.size() - 1)).getStartTime() + 10.0) {
            endTime = lastAct.getStartTime() + 10.0;
        }
        lastAct.setEndTime(endTime);
        Activity newAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId("work", newActivityLinkId);
        Leg newLeg = this.model.getScenario().getPopulation().getFactory().createLeg("car");
        newLeg.setDepartureTime(endTime);
        EditRoutes.relocateFutureLegRoute((Leg)newLeg, (Id)lastAct.getLinkId(), newActivityLinkId, (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
        newAct.setEndTime(Double.POSITIVE_INFINITY);
        planElements.add(newLeg);
        planElements.add(newAct);
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        this.internalInterface.rescheduleActivityEnd(agent);
    }

    final Id<Link> replanCurrentRoute(Id<Person> agentId, String actType) {
        double now = this.model.getTime();
        this.logger.debug(" starting replanCurrentRoute : activity type: {}", (Object)actType);
        Map mapping = this.model.getMobsimAgentMap();
        MobsimAgent agent = (MobsimAgent)mapping.get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        int currentIndex = WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent);
        this.logger.trace("current plan index {}", (Object)currentIndex);
        PlanElement pe = (PlanElement)planElements.get(currentIndex);
        if (!(pe instanceof Activity)) {
            this.logger.error("current plan element is not an activity, unable to replanCurrentRoute");
            return null;
        }
        Activity currentAct = (Activity)pe;
        if (!currentAct.getType().equals("Wait")) {
            this.logger.debug("current activity is not the type of Wait");
            return null;
        }
        this.logger.debug("set end time of the Wait activity to {}  type {} ", (Object)now);
        currentAct.setEndTime(now);
        int targetActIndex = 0;
        Activity targetAct = null;
        for (int i = currentIndex; i < planElements.size(); ++i) {
            Activity act;
            PlanElement element = (PlanElement)planElements.get(i);
            if (!(element instanceof Activity) || !(act = (Activity)element).getType().equals(actType)) continue;
            targetAct = act;
            targetActIndex = i;
            this.logger.trace("target activity plan index: {}", (Object)i);
        }
        if (targetAct == null) {
            this.logger.error("replanCurrentRoute: target activity name not found in the plan");
            return null;
        }
        PlanElement e = (PlanElement)planElements.get(targetActIndex - 1);
        if (!(e instanceof Leg)) {
            this.logger.error("replanCurrentRoute: selected plan element is not a leg, cannot retreive the route");
            return null;
        }
        Leg legWithOptRoute = (Leg)e;
        this.logger.trace("Optimised leg route info before replacement: {}", (Object)legWithOptRoute.toString());
        Route replanRoute = legWithOptRoute.getRoute();
        NetworkRoute netRoute = (NetworkRoute)replanRoute;
        List targetLinkIds = netRoute.getLinkIds();
        this.logger.trace("Size of the retreived links : {}", (Object)targetLinkIds.size());
        HashMap<String, Double> routeDistances = new HashMap<String, Double>();
        for (Id lid : targetLinkIds) {
            Link link = (Link)this.model.getScenario().getNetwork().getLinks().get(lid);
            Node node = link.getFromNode();
            Leg leg = this.model.getScenario().getPopulation().getFactory().createLeg("car");
            EditRoutes.relocateFutureLegRoute((Leg)leg, (Id)currentAct.getLinkId(), (Id)link.getId(), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
            Route r = leg.getRoute();
            routeDistances.put(lid.toString(), r.getDistance());
            this.logger.trace("travel distance from link {}: {}", (Object)lid.toString(), (Object)r.getDistance());
        }
        String connectLinkID = null;
        Double minDist = (Double)Collections.min(routeDistances.values());
        for (Map.Entry entry : routeDistances.entrySet()) {
            if (minDist != entry.getValue()) continue;
            connectLinkID = (String)entry.getKey();
        }
        this.logger.debug("minimum distance : {} is found to linkID : {}", (Object)minDist, connectLinkID);
        Leg connectLeg = this.model.getScenario().getPopulation().getFactory().createLeg("car");
        EditRoutes.relocateFutureLegRoute((Leg)connectLeg, (Id)currentAct.getLinkId(), (Id)Id.createLinkId((String)connectLinkID), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
        Route route = connectLeg.getRoute();
        NetworkRoute netRt = (NetworkRoute)route;
        List connectLegLinks = netRt.getLinkIds();
        this.logger.trace("retreived links of the route of connectLeg : {}", (Object)connectLegLinks.toString());
        ArrayList<Id> targetLegLinkSet = new ArrayList<Id>();
        targetLegLinkSet.addAll(connectLegLinks);
        this.logger.trace(" added linkset of the connect leg to the targetLegLinkSet : {}", (Object)targetLegLinkSet.toString());
        boolean linkDeleted = false;
        for (Id lid : targetLinkIds) {
            if (lid.toString().equals(connectLinkID)) {
                linkDeleted = true;
            }
            if (!linkDeleted) continue;
            targetLegLinkSet.add(lid);
        }
        this.logger.trace("agent {} | added the subset of the optimised route to the targetLegLinkSet: {}", agentId, (Object)targetLegLinkSet.toString());
        int noDelElements = targetActIndex - (currentIndex + 1);
        for (int count = 0; count < noDelElements; ++count) {
            planElements.remove(currentIndex + 1);
        }
        this.logger.trace("agent {} | removed {} elements between currentAct and targetAct | new plan size after removal {}", new Object[]{agentId, noDelElements, planElements.size()});
        Leg targetLeg = this.model.getScenario().getPopulation().getFactory().createLeg("car");
        EditRoutes.relocateFutureLegRoute((Leg)targetLeg, (Id)currentAct.getLinkId(), (Id)targetAct.getLinkId(), (Person)((HasPerson)agent).getPerson(), (Network)this.model.getScenario().getNetwork(), (TripRouter)this.tripRouter);
        Route rout = targetLeg.getRoute();
        NetworkRoute netRout = (NetworkRoute)rout;
        netRout.setLinkIds(currentAct.getLinkId(), targetLegLinkSet, targetAct.getLinkId());
        targetLeg.setRoute((Route)netRout);
        Id targetLink = targetAct.getLinkId();
        planElements.add(currentIndex + 1, targetLeg);
        this.logger.trace("agent {} | set the targetLegLinkSet to the route of the targetLeg and added it to the position of {}", agentId, (Object)(currentIndex + 1));
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        this.internalInterface.rescheduleActivityEnd(agent);
        return targetLink;
    }

    final void removeFutureActivities(Id<Person> agentId) {
        this.logger.debug("inside removeFutureActivities method");
        Map mapping = this.model.getMobsimAgentMap();
        MobsimAgent agent = (MobsimAgent)mapping.get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        int currentPlanIndex = WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent);
        this.logger.debug("plan size before removal : {}", (Object)planElements.size());
        while (planElements.size() > currentPlanIndex + 1) {
            planElements.remove(planElements.size() - 1);
        }
        this.logger.debug("plan size after removal : {}", (Object)planElements.size());
        PlanElement currentPE = (PlanElement)planElements.get(currentPlanIndex);
        if (!(currentPE instanceof Activity)) {
            this.logger.error("current plan element is not an activity - aborting");
            return;
        }
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        this.internalInterface.rescheduleActivityEnd(agent);
    }

    protected final boolean removeActivities(Id<Person> agentId) {
        Map mapping = this.model.getMobsimAgentMap();
        MobsimAgent agent = (MobsimAgent)mapping.get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        while (planElements.size() > 1) {
            planElements.remove(planElements.size() - 1);
        }
        Activity act = (Activity)planElements.get(0);
        act.setEndTime(86400.0);
        act.setMaximumDuration(86400.0);
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        this.internalInterface.rescheduleActivityEnd(agent);
        return true;
    }

    final boolean forceEndActivity(Id<Person> agentId, String actType, double newEndTime) {
        this.logger.debug("received to modify the endtime of activity {}", (Object)actType);
        Map mapping = this.model.getMobsimAgentMap();
        MobsimAgent agent = (MobsimAgent)mapping.get(agentId);
        Activity endAct = null;
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        int currentIndex = WithinDayAgentUtils.getCurrentPlanElementIndex((MobsimAgent)agent);
        int EvacIndex = 100;
        List planElements = plan.getPlanElements();
        PlanElement pe = (PlanElement)planElements.get(currentIndex);
        this.logger.debug("forceEndActivity: agent {} | current plan Index  {} | current time : {} ", new Object[]{agent.getId().toString(), currentIndex, this.model.getTime()});
        if (actType.equals("Current")) {
            if (!(pe instanceof Activity)) {
                this.logger.error("current plan element is not an activity, unable to forceEndActivity");
                return false;
            }
            endAct = (Activity)planElements.get(currentIndex);
        }
        if (actType.equals("Evacuation")) {
            for (int i = currentIndex; i < planElements.size(); ++i) {
                Activity act;
                PlanElement element = (PlanElement)planElements.get(i);
                if (!(element instanceof Activity) || !(act = (Activity)element).getType().equals("Evacuation")) continue;
                endAct = act;
                EvacIndex = i;
            }
        }
        if (endAct == null) {
            this.logger.error("could not find the activity to End");
            return false;
        }
        double ENDTIME = this.model.getTime() + newEndTime;
        this.logger.debug("force end current actvity index {} with new end time  {} ", (Object)EvacIndex, (Object)ENDTIME);
        endAct.setEndTime(ENDTIME);
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        if (currentIndex != 1) {
            this.internalInterface.rescheduleActivityEnd(agent);
        }
        return true;
    }

    public void addTempActivity(Id<Person> agentId) {
        Map mapping = this.model.getMobsimAgentMap();
        MobsimAgent agent = (MobsimAgent)mapping.get(agentId);
        Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)agent);
        List planElements = plan.getPlanElements();
        Activity evacAct = (Activity)planElements.get(2);
        Activity tempAct = this.model.getScenario().getPopulation().getFactory().createActivityFromLinkId("Temp", evacAct.getLinkId());
        tempAct.setEndTime(5.0);
        planElements.add(2, tempAct);
        WithinDayAgentUtils.resetCaches((MobsimAgent)agent);
        this.internalInterface.rescheduleActivityEnd(agent);
    }
}

