/*
 * Decompiled with CFR 0.152.
 */
package io.github.agentsoz.bushfiretute.matsim;

import io.github.agentsoz.bdiabm.BDIServerInterface;
import io.github.agentsoz.bdiabm.data.ActionContent;
import io.github.agentsoz.bdimatsim.AgentActivityEventHandler;
import io.github.agentsoz.bdimatsim.MATSimActionHandler;
import io.github.agentsoz.bdimatsim.MATSimAgent;
import io.github.agentsoz.bdimatsim.MATSimModel;
import io.github.agentsoz.bdimatsim.MATSimPerceptHandler;
import io.github.agentsoz.bdimatsim.MatsimParameterHandler;
import io.github.agentsoz.bdimatsim.Replanner;
import io.github.agentsoz.bdimatsim.app.BDIActionHandler;
import io.github.agentsoz.bdimatsim.app.BDIPerceptHandler;
import io.github.agentsoz.bdimatsim.app.MATSimApplicationInterface;
import io.github.agentsoz.bushfiretute.BDIModel;
import io.github.agentsoz.bushfiretute.BushfireMain;
import io.github.agentsoz.bushfiretute.Config;
import io.github.agentsoz.bushfiretute.MATSimBDIParameterHandler;
import io.github.agentsoz.bushfiretute.Util;
import io.github.agentsoz.bushfiretute.datacollection.ScenarioTwoData;
import io.github.agentsoz.bushfiretute.matsim.CustomReplanner;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.ActivityEndRescheduler;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.network.NetworkImpl;
import org.matsim.core.utils.geometry.CoordImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scenarioTWO.agents.EvacResident;

public class ABMModel
implements MATSimApplicationInterface {
    private final Logger logger = LoggerFactory.getLogger((String)"");
    private final MATSimModel model;
    private final BDIModel bdiModel;
    private Replanner replanner = null;

    public ABMModel(BDIModel bdiModel) {
        this.bdiModel = bdiModel;
        this.model = new MATSimModel((BDIServerInterface)bdiModel, (MatsimParameterHandler)new MATSimBDIParameterHandler());
        this.model.registerPlugin((MATSimApplicationInterface)this);
    }

    public Replanner getReplanner(ActivityEndRescheduler activityEndRescheduler) {
        if (this.replanner == null) {
            this.replanner = new CustomReplanner(this.model, activityEndRescheduler);
        }
        return this.replanner;
    }

    public void notifyBeforeCreatingBDICounterparts(List<Id<Person>> bdiAgentsIDs) {
    }

    public void notifyAfterCreatingBDICounterparts(List<Id<Person>> bdiAgentsIDs) {
        Map links = this.model.getScenario().getNetwork().getLinks();
        for (Id<Person> agentId : bdiAgentsIDs) {
            MATSimAgent agent = this.model.getBDIAgent(agentId);
            EvacResident bdiAgent = this.bdiModel.getBDICounterpart(agentId.toString());
            if (bdiAgent == null) {
                this.logger.warn("No BDI counterpart for MATSim agent '" + agentId + "'. Should not happen, but will keep going");
                continue;
            }
            Plan plan = WithinDayAgentUtils.getModifiablePlan((MobsimAgent)((MobsimAgent)this.model.getMobsimAgentMap().get(agentId)));
            List planElements = plan.getPlanElements();
            double lat = ((Link)links.get(((MobsimAgent)this.model.getMobsimAgentMap().get(agentId)).getCurrentLinkId())).getFromNode().getCoord().getX();
            double lon = ((Link)links.get(((MobsimAgent)this.model.getMobsimAgentMap().get(agentId)).getCurrentLinkId())).getFromNode().getCoord().getY();
            bdiAgent.startLocation = new double[]{lat, lon};
            bdiAgent.currentLocation = "home";
            bdiAgent.log("is at home at location " + lon + "," + lat);
            for (int i = 0; i < planElements.size(); ++i) {
                PlanElement element = (PlanElement)planElements.get(i);
                if (!(element instanceof Activity)) continue;
                Activity act = (Activity)element;
                if (act.getType().equals("Evacuation")) {
                    PlanElement pe = (PlanElement)plan.getPlanElements().get(i + 1);
                    if (!(pe instanceof Leg)) {
                        this.logger.error("Utils : selected plan element to get deptime is not a leg");
                        continue;
                    }
                    Leg depLeg = (Leg)pe;
                    double depTime2 = depLeg.getDepartureTime();
                    this.logger.trace("departure time of the depLeg : {}", (Object)depTime2);
                    bdiAgent.setDepTime(depTime2);
                }
                if (!act.getType().equals("Safe")) continue;
                double safeX = act.getCoord().getX();
                double safeY = act.getCoord().getY();
                bdiAgent.endLocation = new double[]{safeX, safeY};
                bdiAgent.log("safe location is at " + safeX + "," + safeY);
            }
            this.assignDependentPersons(bdiAgent);
        }
    }

    public void registerNewBDIActions(MATSimActionHandler withHandler) {
        withHandler.registerBDIAction("drive to", new BDIActionHandler(){

            public boolean handle(String agentID, String actionID, Object[] args, MATSimModel model) {
                double[] coords = (double[])args[1];
                if (!(args[1] instanceof double[])) {
                    throw new RuntimeException("Destination coordinates are not given");
                }
                Id newLinkId = ((NetworkImpl)model.getScenario().getNetwork()).getNearestLinkExactly((Coord)new CoordImpl(coords[0], coords[1])).getId();
                ((CustomReplanner)model.getReplanner()).addNewLegToPlan((Id<Person>)Id.createPersonId((String)agentID), (Id<Link>)newLinkId, (String)args[2]);
                MATSimAgent agent = model.getBDIAgent(agentID);
                EvacResident bdiAgent = ABMModel.this.bdiModel.getBDICounterpart(agentID.toString());
                bdiAgent.log("has started driving to coords " + coords[0] + "," + coords[1] + " i.e. link " + newLinkId.toString());
                agent.getPerceptHandler().registerBDIPerceptHandler(agent.getAgentID(), AgentActivityEventHandler.MonitoredEventType.ArrivedAtDestination, newLinkId, new BDIPerceptHandler(){

                    public boolean handle(Id<Person> agentId, Id<Link> linkId, AgentActivityEventHandler.MonitoredEventType monitoredEvent, MATSimModel model) {
                        MATSimAgent agent = model.getBDIAgent(agentId);
                        EvacResident bdiAgent = ABMModel.this.bdiModel.getBDICounterpart(agentId.toString());
                        Object[] params = new Object[]{linkId.toString(), Long.toString(bdiAgent.getCurrentTime())};
                        agent.getActionContainer().register("drive to", params);
                        agent.getActionContainer().get("drive to").setState(ActionContent.State.PASSED);
                        agent.getPerceptContainer().put("Arrived", (Object)params);
                        return true;
                    }
                });
                return true;
            }
        });
        withHandler.registerBDIAction("connect to", new BDIActionHandler(){

            public boolean handle(String agentID, String actionID, Object[] args, MATSimModel model) {
                String destination = (String)args[1];
                Id<Link> newLinkId = ((CustomReplanner)model.getReplanner()).replanCurrentRoute((Id<Person>)Id.createPersonId((String)agentID), destination);
                if (newLinkId == null) {
                    ABMModel.this.logger.warn("CONNECT_TO: returned a null link from the target activity");
                    return true;
                }
                MATSimAgent agent = model.getBDIAgent(agentID);
                EvacResident bdiAgent = ABMModel.this.bdiModel.getBDICounterpart(agentID.toString());
                bdiAgent.log("replanned to drive to connecting link " + newLinkId.toString());
                agent.getPerceptHandler().registerBDIPerceptHandler(agent.getAgentID(), AgentActivityEventHandler.MonitoredEventType.ArrivedAtDestination, newLinkId, new BDIPerceptHandler(){

                    public boolean handle(Id<Person> agentId, Id<Link> linkId, AgentActivityEventHandler.MonitoredEventType monitoredEvent, MATSimModel model) {
                        MATSimAgent agent = model.getBDIAgent(agentId);
                        EvacResident bdiAgent = ABMModel.this.bdiModel.getBDICounterpart(agentId.toString());
                        Object[] params = new Object[]{linkId.toString(), Long.toString(bdiAgent.getCurrentTime())};
                        agent.getActionContainer().register("connect to", params);
                        agent.getActionContainer().get("connect to").setState(ActionContent.State.PASSED);
                        agent.getPerceptContainer().put("Arrived to connect to", (Object)params);
                        return true;
                    }
                });
                return true;
            }
        });
        withHandler.registerBDIAction("drive to and pick up", new BDIActionHandler(){

            public boolean handle(String agentID, String actionID, Object[] args, MATSimModel model) {
                double[] coords = (double[])args[1];
                if (!(args[1] instanceof double[])) {
                    throw new RuntimeException("Destination coordinates are not given");
                }
                Id newLinkId = ((NetworkImpl)model.getScenario().getNetwork()).getNearestLinkExactly((Coord)new CoordImpl(coords[0], coords[1])).getId();
                ((CustomReplanner)model.getReplanner()).addNewLegAndActvityToPlan((Id<Person>)Id.createPersonId((String)agentID), (Id<Link>)newLinkId, (Integer)args[3]);
                MATSimAgent agent = model.getBDIAgent(agentID);
                EvacResident bdiAgent = ABMModel.this.bdiModel.getBDICounterpart(agentID.toString());
                bdiAgent.log("will drive to pickup from coords " + coords[0] + "," + coords[1] + " i.e. link " + newLinkId.toString());
                agent.getPerceptHandler().registerBDIPerceptHandler(agent.getAgentID(), AgentActivityEventHandler.MonitoredEventType.EndedActivity, newLinkId, new BDIPerceptHandler(){

                    public boolean handle(Id<Person> agentId, Id<Link> linkId, AgentActivityEventHandler.MonitoredEventType monitoredEvent, MATSimModel model) {
                        MATSimAgent agent = model.getBDIAgent(agentId);
                        Object[] params = new Object[]{linkId.toString()};
                        agent.getActionContainer().register("drive to and pick up", params);
                        agent.getActionContainer().get("drive to and pick up").setState(ActionContent.State.PASSED);
                        agent.getPerceptContainer().put("arrived and picked up", (Object)params);
                        return true;
                    }
                });
                return true;
            }
        });
        withHandler.registerBDIAction("set drive time", new BDIActionHandler(){

            public boolean handle(String agentID, String actionID, Object[] args, MATSimModel model) {
                double newEndTime = (Double)args[1];
                String actType = (String)args[2];
                ((CustomReplanner)model.getReplanner()).forceEndActivity((Id<Person>)Id.createPersonId((String)agentID), actType, newEndTime);
                MATSimAgent agent = model.getBDIAgent(agentID);
                EvacResident bdiAgent = ABMModel.this.bdiModel.getBDICounterpart(agentID.toString());
                bdiAgent.log("has set the drive time for activity " + actType + " to " + newEndTime);
                Object[] params = new Object[]{};
                agent.getActionContainer().register("set drive time", params);
                agent.getActionContainer().get("set drive time").setState(ActionContent.State.PASSED);
                return true;
            }
        });
    }

    public void registerNewBDIPercepts(MATSimPerceptHandler withHandler) {
        for (Id agentID : this.model.getBDIAgentIDs()) {
            MATSimAgent agent = this.model.getBDIAgent(agentID);
            EvacResident bdiAgent = this.bdiModel.getBDICounterpart(agentID.toString());
            Id newLinkId = ((NetworkImpl)this.model.getScenario().getNetwork()).getNearestLinkExactly((Coord)new CoordImpl(bdiAgent.endLocation[0], bdiAgent.endLocation[1])).getId();
            agent.getPerceptHandler().registerBDIPerceptHandler(agent.getAgentID(), AgentActivityEventHandler.MonitoredEventType.ArrivedAtDestination, newLinkId, new BDIPerceptHandler(){

                public boolean handle(Id<Person> agentId, Id<Link> linkId, AgentActivityEventHandler.MonitoredEventType monitoredEvent, MATSimModel model) {
                    MATSimAgent agent = model.getBDIAgent(agentId);
                    EvacResident bdiAgent = ABMModel.this.bdiModel.getBDICounterpart(agentId.toString());
                    Object[] params = new Object[]{"Safe", Long.toString(bdiAgent.getCurrentTime())};
                    agent.getPerceptContainer().put("Arrived", (Object)params);
                    return true;
                }
            });
        }
    }

    public void run(String file, String[] args) {
        this.model.run(file, args);
    }

    private void assignDependentPersons(EvacResident bdiAgent) {
        if (ScenarioTwoData.totPickups <= Config.getMaxPickUps()) {
            double[] pDependents = new double[]{Config.getProportionWithKids(), Config.getProportionWithRelatives()};
            pDependents = Util.normalise(pDependents);
            Random random = BushfireMain.getRandom();
            if (random.nextDouble() < pDependents[0]) {
                ++ScenarioTwoData.agentsWithKids;
                double[] sclCords = Config.getRandomSchoolCoords(bdiAgent.getId(), bdiAgent.startLocation);
                if (sclCords != null) {
                    bdiAgent.kidsNeedPickUp = true;
                    bdiAgent.schoolLocation = sclCords;
                    bdiAgent.prepared_to_evac_flag = false;
                    ++ScenarioTwoData.totPickups;
                    bdiAgent.log("has children at school coords " + sclCords[0] + "," + sclCords[1]);
                } else {
                    bdiAgent.log("has children but there are no schools nearby");
                    ++ScenarioTwoData.agentsWithKidsNoSchools;
                }
            }
            if (random.nextDouble() < pDependents[1]) {
                ++ScenarioTwoData.agentsWithRels;
                bdiAgent.relsNeedPickUp = true;
                bdiAgent.prepared_to_evac_flag = false;
                ++ScenarioTwoData.totPickups;
                bdiAgent.log("has relatives");
            }
            if (!bdiAgent.relsNeedPickUp && !bdiAgent.kidsNeedPickUp) {
                bdiAgent.log("has neither children nor relatives");
            }
        }
    }
}

