/*
 * Decompiled with CFR 0.152.
 */
package io.github.agentsoz.bushfiretute.datamodels;

import java.util.Collection;

public class Location {
    protected String name;
    private double easting;
    private double northing;
    private String type;

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setEasting(double e) {
        this.easting = e;
    }

    public double getEasting() {
        return this.easting;
    }

    public void setNorthing(double n) {
        this.northing = n;
    }

    public double getNorthing() {
        return this.northing;
    }

    public double[] getCoordinates() {
        return new double[]{this.easting, this.northing};
    }

    public void setType(String s) {
        this.type = s;
    }

    public String getType() {
        return this.type;
    }

    public Location(String n, String t, double east, double north) {
        this.name = n;
        this.type = t;
        this.easting = east;
        this.northing = north;
    }

    public String toString() {
        return "(" + this.name + ", coords=" + this.easting + "," + this.northing + ")";
    }

    public static double[] average(Collection<Location> locations) {
        double lat = 0.0;
        double lon = 0.0;
        for (Location l : locations) {
            lat += l.getEasting();
            lon += l.getNorthing();
        }
        return new double[]{lat / (double)locations.size(), lon / (double)locations.size()};
    }

    public static double distance(Location a, Location b) {
        return Location.distance(a.getCoordinates(), b.getCoordinates());
    }

    public static double distance(double[] a, double[] b) {
        double dx = b[1] - a[1];
        double dy = b[0] - a[0];
        return Math.sqrt(dx * dx + dy * dy) / 1000.0;
    }
}

