/*
 * Decompiled with CFR 0.152.
 */
package io.github.agentsoz.bushfiretute;

import java.util.Random;

public class Util {
    public static double[] normalise(double[] values) {
        double sum = 0.0;
        if (values == null || values.length <= 1) {
            return values;
        }
        for (double d : values) {
            sum += Math.abs(d);
        }
        if (sum == 0.0) {
            return values;
        }
        double[] norm = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            norm[i] = values[i] / sum;
        }
        return norm;
    }

    public static double[] cumulate(double[] values) {
        if (values == null || values.length <= 1) {
            return values;
        }
        double[] out = new double[values.length];
        out[0] = values[0];
        for (int i = 1; i < values.length; ++i) {
            out[i] = out[i - 1] + values[i];
        }
        return out;
    }

    static int selectIndexFromCumulativeProbabilities(double[] values, Random random) {
        int index = -1;
        double roll = random.nextDouble();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                if (!(roll <= values[i])) continue;
                index = i;
                break;
            }
        }
        return index;
    }
}

