/*
 * Decompiled with CFR 0.152.
 */
package io.github.agentsoz.bushfiretute;

import io.github.agentsoz.bushfiretute.datamodels.Location;
import io.github.agentsoz.bushfiretute.datamodels.School;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger((String)"");
    private static String configFile = null;
    private static int scenario = 0;
    private static String reportFile = "bushfire-evacuation-report.txt";
    private static String bdiSimFile = null;
    private static String matSimFile = null;
    private static String geographyFile = null;
    private static int numBDIAgents = 1;
    private static String fireFile = null;
    private static String controllerFile = null;
    private static boolean useGUI = false;
    private static boolean bypassController = true;
    private static boolean controllerUserInput = false;
    private static boolean dieOnDisconnect = false;
    private static int port = -1;
    private static double proportionWithKids = 0.0;
    private static double maxDistanceToSchool = 0.0;
    private static double proportionWithRelatives = 0.0;
    private static int maxDistanceToRelatives = 0;
    private static int maxPickups = 0;
    private static int max_pickuptime = 0;
    private static int depTrigTime = 0;
    private static int seed = 0;
    private static int diffTurn = 0;
    private static int avgLinks = 0;
    private static String networkType = " ";
    private static double act_threshold = 0.0;
    private static double volatility = 0.0;
    private static double maxRandomPanicRange = 0.0;
    private static double minRandomPanicRange = 0.0;
    private static double maxDistanceToNeighbours = 0.0;
    private static int max_neighbours = 0;
    private static int min_neighbours = 0;
    private static int max_friends = 0;
    private static int min_friends = 0;
    private static int max_familyMembers = 0;
    private static int min_familyMembers = 0;
    private static double high_panic = 0.0;
    private static double med_panic = 0.0;
    private static double low_panic = 0.0;
    private static HashMap<Integer, School> schools = new HashMap();
    private static ArrayList<String> agentsWithoutSchools = new ArrayList();
    private static Image image = new Image();
    private static String fireFireCoordinateSystem = "longlat";
    private static String coordinate_system = "longlat";
    private static int schoolCount = 0;
    static Random rand = new Random();

    public static Image getImage() {
        return image;
    }

    public int getAgentsWithoutSchool() {
        return agentsWithoutSchools.size();
    }

    public static HashMap<Integer, School> getSchools() {
        return schools;
    }

    public static int getMaxPickUps() {
        int maxPickups = (int)(proportionWithRelatives * 38343.0) + 10;
        return maxPickups;
    }

    public static int getPickUpTime() {
        return max_pickuptime;
    }

    public static String getReportFile() {
        return reportFile;
    }

    public static String getMatSimFile() {
        return matSimFile;
    }

    public static String getFireFile() {
        return fireFile;
    }

    public static int getScenario() {
        return scenario;
    }

    public static int getPort() {
        return port;
    }

    public static int getNumBDIAgents() {
        return numBDIAgents;
    }

    public static int getSeed() {
        return seed;
    }

    public static int getDiffturn() {
        return diffTurn;
    }

    public static int getAvgLinks() {
        return avgLinks;
    }

    public static String getNetworkType() {
        return networkType;
    }

    public static double getActivationThreshold() {
        return act_threshold;
    }

    public static boolean getBypassController() {
        return bypassController;
    }

    public static boolean getDieOnDisconnect() {
        return dieOnDisconnect;
    }

    public static double getProportionWithKids() {
        return proportionWithKids;
    }

    public static double getmaxDistanceToSchool() {
        return maxDistanceToSchool;
    }

    public static double getHighPanicThreshold() {
        return high_panic;
    }

    public static double getMedPanicThreshold() {
        return med_panic;
    }

    public static double getLowPanicThreshold() {
        return low_panic;
    }

    public static double getVolatility() {
        return volatility;
    }

    public static double getMinRandomPanicRange() {
        return minRandomPanicRange;
    }

    public static double getMaxRandomPanicRange() {
        return maxRandomPanicRange;
    }

    public static double getProportionWithRelatives() {
        return proportionWithRelatives;
    }

    public static int getMaxDistanceToRelatives() {
        return maxDistanceToRelatives;
    }

    public static double getMaxDistanceToNeighbours() {
        return maxDistanceToNeighbours;
    }

    public static int getMaxNeighboursLimit() {
        return max_neighbours;
    }

    public static int getMinNeighboursLimit() {
        return min_neighbours;
    }

    public static int getMaxFriendsLimit() {
        return max_friends;
    }

    public static int getMinFriendsLimit() {
        return min_friends;
    }

    public static int getMaxFamiliesLimit() {
        return max_familyMembers;
    }

    public static int getMinFamiliesLimit() {
        return min_familyMembers;
    }

    public static String getCoordinate_system() {
        return coordinate_system;
    }

    public static String getFireFireCoordinateSystem() {
        return fireFireCoordinateSystem;
    }

    public static boolean getUseGUI() {
        return useGUI;
    }

    public static void setUseGUI(boolean b) {
        useGUI = b;
    }

    public static String getConfigFile() {
        return configFile;
    }

    public static void setConfigFile(String string) {
        configFile = string;
    }

    public static int getDepartureTriggerTime() {
        return depTrigTime;
    }

    public static boolean readConfig() {
        String s;
        String nodeName;
        Node node;
        int i;
        NodeList nl;
        Document doc;
        DocumentBuilder db;
        DocumentBuilderFactory dbf;
        if (configFile == null) {
            logger.error("No configuration file given");
            return false;
        }
        logger.info("Loading configuration from '" + configFile + "'");
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            doc = db.parse(new FileInputStream(configFile));
            nl = doc.getDocumentElement().getChildNodes();
            for (i = 0; i < nl.getLength(); ++i) {
                node = nl.item(i);
                if (!(node instanceof Element)) continue;
                nodeName = node.getNodeName();
                logger.trace("found node " + nodeName);
                if (nodeName.equals("reportfile")) {
                    reportFile = node.getAttributes().getNamedItem("name").getNodeValue();
                }
                if (nodeName.equals("bdisimfile")) {
                    bdiSimFile = node.getAttributes().getNamedItem("name").getNodeValue();
                }
                if (nodeName.equals("matsimfile")) {
                    matSimFile = node.getAttributes().getNamedItem("name").getNodeValue();
                }
                if (nodeName.equals("firefile")) {
                    fireFile = node.getAttributes().getNamedItem("name").getNodeValue();
                    fireFireCoordinateSystem = node.getAttributes().getNamedItem("coordinates").getNodeValue();
                }
                if (nodeName.equals("controllerfile")) {
                    controllerFile = node.getAttributes().getNamedItem("name").getNodeValue();
                }
                if (nodeName.equals("geographyfile")) {
                    geographyFile = node.getAttributes().getNamedItem("name").getNodeValue();
                    coordinate_system = node.getAttributes().getNamedItem("coordinates").getNodeValue();
                }
                if (nodeName.equals("port") && useGUI) {
                    String p = node.getAttributes().getNamedItem("number").getNodeValue();
                    port = Integer.parseInt(p);
                    try {
                        String d = node.getAttributes().getNamedItem("die_on_disconnect").getNodeValue();
                        dieOnDisconnect = Boolean.parseBoolean(d);
                    }
                    catch (Exception d) {
                        // empty catch block
                    }
                }
                if (nodeName.equals("bdiagents")) {
                    String n = node.getAttributes().getNamedItem("number").getNodeValue();
                    try {
                        numBDIAgents = Integer.parseInt(n);
                    }
                    catch (Exception e) {
                        System.err.println("WARNING: Could not read number of BDI agents from configuration file (will use default '" + numBDIAgents + "'): " + e.getMessage());
                    }
                }
                if (nodeName.equals("demographics")) {
                    try {
                        String k = node.getAttributes().getNamedItem("kids").getNodeValue();
                        proportionWithKids = Double.parseDouble(k);
                        String r = node.getAttributes().getNamedItem("relatives").getNodeValue();
                        proportionWithRelatives = Double.parseDouble(r);
                        String d = node.getAttributes().getNamedItem("max_distance_to_school").getNodeValue();
                        maxDistanceToSchool = Double.parseDouble(d);
                        String dist = node.getAttributes().getNamedItem("max_distance_to_relatives").getNodeValue();
                        maxDistanceToRelatives = Integer.parseInt(dist);
                        String max_pickup = node.getAttributes().getNamedItem("max_pickuptime_for_kids_and_rels").getNodeValue();
                        max_pickuptime = Integer.parseInt(max_pickup);
                        String val = node.getAttributes().getNamedItem("departure_Trigger_Time").getNodeValue();
                        depTrigTime = Integer.parseInt(val);
                        String nei_dist = node.getAttributes().getNamedItem("max_distance_to_neighbours").getNodeValue();
                        maxDistanceToNeighbours = Double.parseDouble(nei_dist);
                        String maxN = node.getAttributes().getNamedItem("max_neighbours").getNodeValue();
                        max_neighbours = Integer.parseInt(maxN);
                        String minN = node.getAttributes().getNamedItem("min_neighbours").getNodeValue();
                        min_neighbours = Integer.parseInt(minN);
                        String maxF = node.getAttributes().getNamedItem("max_friends").getNodeValue();
                        max_friends = Integer.parseInt(maxF);
                        String minF = node.getAttributes().getNamedItem("min_friends").getNodeValue();
                        min_friends = Integer.parseInt(minF);
                        String maxFam = node.getAttributes().getNamedItem("max_familyMembers").getNodeValue();
                        max_familyMembers = Integer.parseInt(maxFam);
                        String minFam = node.getAttributes().getNamedItem("min_familyMembers").getNodeValue();
                        min_familyMembers = Integer.parseInt(minFam);
                    }
                    catch (Exception e) {
                        System.err.println("WARNING: could not read from the node demographics " + e.getMessage());
                    }
                }
                if (nodeName.equals("snmodel")) {
                    try {
                        String type;
                        s = node.getAttributes().getNamedItem("diff_seed").getNodeValue();
                        seed = Integer.parseInt(s);
                        String t = node.getAttributes().getNamedItem("diff_turn").getNodeValue();
                        diffTurn = Integer.parseInt(t);
                        String links = node.getAttributes().getNamedItem("avg_links").getNodeValue();
                        avgLinks = Integer.parseInt(links);
                        networkType = type = node.getAttributes().getNamedItem("networkType").getNodeValue();
                        String thr = node.getAttributes().getNamedItem("panic_act_threshold").getNodeValue();
                        act_threshold = Double.parseDouble(thr);
                        String high = node.getAttributes().getNamedItem("high_panic_threshold").getNodeValue();
                        high_panic = Double.parseDouble(high);
                        String med = node.getAttributes().getNamedItem("medium_panic_threshold").getNodeValue();
                        med_panic = Double.parseDouble(med);
                        String low = node.getAttributes().getNamedItem("low_panic_threshold").getNodeValue();
                        low_panic = Double.parseDouble(low);
                        String maxP = node.getAttributes().getNamedItem("maxRandomPanicRange").getNodeValue();
                        maxRandomPanicRange = Double.parseDouble(maxP);
                        String minP = node.getAttributes().getNamedItem("minRandomPanicRange").getNodeValue();
                        minRandomPanicRange = Double.parseDouble(minP);
                        String vol = node.getAttributes().getNamedItem("volatility").getNodeValue();
                        volatility = Double.parseDouble(vol);
                    }
                    catch (Exception e) {
                        System.err.println("WARNING: could not read from the node snmodel " + e.getMessage());
                    }
                }
                if (nodeName.equals("scenario")) {
                    String no = node.getAttributes().getNamedItem("scenarioType").getNodeValue();
                    scenario = Integer.parseInt(no);
                }
                if (!nodeName.equals("image")) continue;
                try {
                    String w = node.getAttributes().getNamedItem("west").getNodeValue();
                    String e = node.getAttributes().getNamedItem("east").getNodeValue();
                    String n = node.getAttributes().getNamedItem("north").getNodeValue();
                    String s2 = node.getAttributes().getNamedItem("south").getNodeValue();
                    Config.image.file = node.getAttributes().getNamedItem("file").getNodeValue();
                    Config.image.west = Double.parseDouble(w);
                    Config.image.east = Double.parseDouble(e);
                    Config.image.north = Double.parseDouble(n);
                    Config.image.south = Double.parseDouble(s2);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR while reading config: " + e.getMessage());
        }
        if (controllerFile != null) {
            try {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
                doc = db.parse(new FileInputStream(controllerFile));
                nl = doc.getDocumentElement().getChildNodes();
                for (i = 0; i < nl.getLength(); ++i) {
                    node = nl.item(i);
                    if (!(node instanceof Element)) continue;
                    nodeName = node.getNodeName();
                    logger.trace("found node " + nodeName);
                    if (!nodeName.equals("bypassing")) continue;
                    s = node.getAttributes().getNamedItem("bypass").getNodeValue();
                    bypassController = Boolean.parseBoolean(s);
                    s = node.getAttributes().getNamedItem("userControl").getNodeValue();
                    controllerUserInput = Boolean.parseBoolean(s);
                }
            }
            catch (Exception e) {
                logger.error("unable to read controller file '" + controllerFile + "' :" + e.getMessage());
                return false;
            }
        } else {
            bypassController = true;
        }
        logger.debug("matSimFilefile = " + matSimFile);
        logger.debug("bdiSimFile = " + bdiSimFile);
        logger.debug("geographyFile = " + geographyFile);
        if (geographyFile != null) {
            if (Config.readGeography()) {
                Config.printSchools();
            } else {
                return false;
            }
        }
        return matSimFile != null;
    }

    private static boolean readGeography() {
        boolean result = true;
        logger.info("loading geography file " + geographyFile);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new FileInputStream(geographyFile));
            NodeList nl = doc.getDocumentElement().getChildNodes();
            ArrayList<Node> locationNodes = new ArrayList<Node>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                String nodeName = node.getNodeName();
                logger.trace("found node " + nodeName);
                if (!nodeName.equals("location")) continue;
                locationNodes.add(node);
            }
            for (Node n : locationNodes) {
                if (Config.readSchool(n)) continue;
                result = false;
            }
        }
        catch (Exception e) {
            logger.error("Unable to read geography file " + geographyFile);
            return false;
        }
        if (schools.size() == 0) {
            logger.error("No schools configured in " + geographyFile);
            return false;
        }
        return result;
    }

    private static boolean readSchool(Node node) {
        boolean result = true;
        try {
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").getNodeValue();
            String eastStr = node.getAttributes().getNamedItem("easting").getNodeValue();
            String northStr = node.getAttributes().getNamedItem("northing").getNodeValue();
            double easting = Double.parseDouble(eastStr);
            double northing = Double.parseDouble(northStr);
            School scl = new School(schoolCount, name, type, easting, northing);
            schools.put(schoolCount, scl);
            ++schoolCount;
        }
        catch (Exception e) {
            logger.error("Could not read location from config file: " + e.getMessage());
            result = false;
        }
        return result;
    }

    public static void readSchoolFromList(HashMap<Double, Double> schoolLocs) {
        for (Map.Entry<Double, Double> entry : schoolLocs.entrySet()) {
            double east = entry.getKey();
            double north = entry.getValue();
            School scl = new School(schoolCount, "school", "s", east, north);
            schools.put(schoolCount, scl);
            ++schoolCount;
        }
        Config.printSchools();
    }

    private static void printSchools() {
        for (Integer key : schools.keySet()) {
            School scl = schools.get(key);
            logger.trace("school info : {} ", (Object)scl.toString());
        }
    }

    public static School getRandomSchool(String id, double[] agentLoc) {
        double distRange = maxDistanceToSchool;
        School selectedSchool = null;
        ArrayList<School> schoolsWithinDistance = new ArrayList<School>();
        for (School school : schools.values()) {
            if (!(Location.distance(agentLoc, school.getCoordinates()) <= distRange)) continue;
            schoolsWithinDistance.add(school);
        }
        if (!schoolsWithinDistance.isEmpty()) {
            Random rand = new Random();
            logger.debug("number of schools within the range : {}", (Object)schoolsWithinDistance.size());
            logger.debug(" selected school array : {}", (Object)schoolsWithinDistance.toString());
            int num = rand.nextInt(schoolsWithinDistance.size());
            selectedSchool = (School)schoolsWithinDistance.get(num);
            logger.debug("selected school ID : " + selectedSchool.getID());
            School scl = schools.get(selectedSchool.getID());
            scl.addKid(id);
            logger.trace("added kid {} to school {} ", (Object)id, (Object)scl.getID());
        } else {
            agentsWithoutSchools.add(id);
        }
        return selectedSchool;
    }

    public static double[] getRandomSchoolCoords(String id, double[] agentLoc) {
        double[] coords = null;
        School randomSchool = Config.getRandomSchool(id, agentLoc);
        if (randomSchool != null) {
            coords = randomSchool.getCoordinates();
        }
        return coords;
    }

    public static int getRandomSchoolID(String id, double[] agentLoc) {
        int schoolID = -1;
        School randomSchool = Config.getRandomSchool(id, agentLoc);
        if (randomSchool != null) {
            schoolID = randomSchool.getID();
        }
        return schoolID;
    }

    public static void testGetRandomSchool() {
        double[] test = new double[]{1500.0, 1000.0};
        School school = Config.getRandomSchool("1", test);
        logger.debug("selected school coords : easting - {} northing -{}", (Object)school.getEasting(), (Object)school.getNorthing());
    }

    public static class Image {
        public String file;
        public double west;
        public double east;
        public double north;
        public double south;

        public String toString() {
            return "west[" + this.west + "] east[" + this.east + "] north[" + this.north + "] south[" + this.south + "]";
        }
    }
}

