/*
 * Decompiled with CFR 0.152.
 */
package io.github.agentsoz.bushfiretute;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import io.github.agentsoz.bushfiretute.BDIModel;
import io.github.agentsoz.bushfiretute.Config;
import io.github.agentsoz.bushfiretute.matsim.ABMModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;
import org.slf4j.LoggerFactory;

public class BushfireMain {
    private static String logFile = BushfireMain.class.getSimpleName() + ".log";
    private static String outFile = null;
    private static Level logLevel = Level.INFO;
    private static Logger logger = null;
    public static PrintStream writer;
    private static final Random random;
    private static Long seed;

    public static void main(String[] args) throws IOException {
        BushfireMain.parse(args);
        logger = BushfireMain.createLogger("", logFile);
        if (outFile != null) {
            try {
                writer = new PrintStream(outFile, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            writer = System.out;
        }
        if (seed != null) {
            random.setSeed(seed);
        }
        if (!Config.readConfig()) {
            logger.error("Failed to load configuration from '" + Config.getConfigFile() + "'. Aborting");
            System.exit(-1);
        }
        BDIModel bdiModel = new BDIModel();
        ABMModel abmModel = new ABMModel(bdiModel);
        String[] margs = new String[]{Config.getMatSimFile()};
        String s = "starting matsim with args:";
        for (int i = 0; i < margs.length; ++i) {
            s = s + margs[i];
        }
        logger.info(s);
        abmModel.run(null, margs);
        bdiModel.finish();
        writer.close();
        System.exit(0);
    }

    public static void parse(String[] args) {
        block16: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-c": {
                    if (i + 1 >= args.length) continue block16;
                    Config.setConfigFile(args[++i]);
                    continue block16;
                }
                case "-h": {
                    BushfireMain.exit(null);
                }
                case "-logfile": {
                    if (i + 1 >= args.length) continue block16;
                    logFile = args[++i];
                    continue block16;
                }
                case "-loglevel": {
                    if (i + 1 >= args.length) continue block16;
                    ++i;
                    try {
                        logLevel = Level.toLevel((String)args[i]);
                    }
                    catch (Exception e) {
                        System.err.println("Could not parse log level '" + args[i] + "' : " + e.getMessage());
                    }
                    continue block16;
                }
                case "-outfile": {
                    if (i + 1 >= args.length) continue block16;
                    outFile = args[++i];
                }
            }
        }
    }

    public static String usage() {
        return "usage:\n  -c FILE            simulation configuration file\n  -h                 print this help message and exit\n  -logfile FILE      logging output file name (default is '" + logFile + "')\n  -loglevel LEVEL    log level; one of ERROR,WARN,INFO,DEBUG,TRACE (default is '" + logLevel + "')\n  -outfile FILE      program output file name (default is system out)\n\n";
    }

    private static void exit(String err) {
        if (err != null) {
            System.err.println("\nERROR: " + err + "\n");
        }
        System.out.println(BushfireMain.usage());
        System.exit(0);
    }

    private static Logger createLogger(String string, String file) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %caller{1}%msg%n%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(file);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setAppend(false);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        Logger logger = (Logger)LoggerFactory.getLogger((String)string);
        logger.detachAndStopAllAppenders();
        logger.addAppender((Appender)fileAppender);
        logger.setLevel(logLevel);
        logger.setAdditive(true);
        return logger;
    }

    public static Random getRandom() {
        return random;
    }

    static {
        random = new Random();
        seed = null;
    }
}

