/*
 * Decompiled with CFR 0.152.
 */
package io.github.agentsoz.bushfiretute;

import aos.jack.jak.agent.Agent;
import io.github.agentsoz.abmjack.JACKModel;
import io.github.agentsoz.abmjack.shared.ActionManager;
import io.github.agentsoz.abmjack.shared.GlobalTime;
import io.github.agentsoz.bdiabm.ABMServerInterface;
import io.github.agentsoz.bdiabm.data.ActionContent;
import io.github.agentsoz.bdiabm.data.AgentDataContainer;
import io.github.agentsoz.bushfiretute.BushfireMain;
import io.github.agentsoz.bushfiretute.Config;
import io.github.agentsoz.bushfiretute.bdi.BdiConnector;
import io.github.agentsoz.bushfiretute.datacollection.ScenarioTwoData;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scenarioTWO.agents.EvacResident;

public class BDIModel
extends JACKModel {
    final Logger logger = LoggerFactory.getLogger((String)"");
    protected BdiConnector bdiConnector;
    int timeStepcount = 0;
    static boolean firePerceptAdded = false;

    public void takeControl(AgentDataContainer adc) {
        if ((double)GlobalTime.time.getTime() == 4.0 && !firePerceptAdded) {
            adc.getOrCreate("global").getPerceptContainer().put("FireAlert", (Object)"bushfire started");
            this.logger.debug("broadcasted fire alert global percept at timestep : {}", (Object)GlobalTime.time.getTime());
            firePerceptAdded = true;
        }
        GlobalTime.increaseNewTime();
        super.takeControl(adc);
        this.checkDepartureFromHome(adc);
    }

    public void checkDepartureFromHome(AgentDataContainer adc) {
        for (Map.Entry agentEntry : this.agents.entrySet()) {
            String agentID = (String)agentEntry.getKey();
            EvacResident agent = (EvacResident)((Object)agentEntry.getValue());
            if (!agent.waitAtHomeFlag || !(agent.getTimeLeftToEvac() <= (double)Config.getDepartureTriggerTime())) continue;
            adc.getOrCreate(agentID).getPerceptContainer().put("leave now", (Object)" start departure");
        }
    }

    public void setup(ABMServerInterface abmServer) {
        this.bdiConnector = new BdiConnector();
        this.bdiConnector.print_S2JACKModelConfigs();
    }

    public void finish() {
        this.logger.debug("agents with kids: {}| agents with Relatives: {}| agents with schools: {}| agents with kids but no schools: {}| totPickups: {} | maxPickups: {}", new Object[]{ScenarioTwoData.agentsWithKids, ScenarioTwoData.agentsWithRels, ScenarioTwoData.agentsWithSchools, ScenarioTwoData.agentsWithKidsNoSchools, ScenarioTwoData.totPickups, Config.getMaxPickUps()});
        ScenarioTwoData.writeToFile();
        ScenarioTwoData.writeConnectToDepTimesToFile();
        this.logger.info("shut down");
    }

    public void packageAction(String agentID, String actionID, Object[] parameters) {
        if ((String)parameters[0] == "drive to") {
            this.logger.trace("received a DRIVETO action in package action");
            this.startDriving(agentID, parameters);
        }
        if ((String)parameters[0] == "drive to and pick up") {
            this.logger.trace("received a DRIVETO_AND_PICKUP action in package action");
            this.callSuperPackageAction(agentID, "drive to and pick up", parameters);
        }
        if ((String)parameters[0] == "pick up") {
            this.logger.trace("received a PICKUP action in package action");
            this.callSuperPackageAction(agentID, "pick up", parameters);
        }
        if ((String)parameters[0] == "set drive time") {
            this.logger.trace("received a SET_DRIVE_TIME action in package action");
            this.callSuperPackageAction(agentID, "set drive time", parameters);
        }
        if ((String)parameters[0] == "connect to") {
            this.logger.trace("received a CONNECT_TO action in package action");
            this.startDriving(agentID, parameters);
        }
    }

    protected void startDriving(String agentID, Object[] parameters) {
        String action = (String)parameters[0];
        if (action.equals("drive to")) {
            this.callSuperPackageAction(agentID, "drive to", parameters);
        } else if (action.equals("connect to")) {
            this.callSuperPackageAction(agentID, "connect to", parameters);
        }
    }

    protected void callSuperPackageAction(String agentID, String action, Object[] parameters) {
        super.packageAction(agentID, action, parameters);
    }

    public Agent createAgent(String agentID, Object[] initData) {
        this.logger.debug("agent {} initiated from bushfire application", (Object)agentID);
        return new EvacResident(agentID, this.bdiConnector, (ActionManager)this, BushfireMain.writer);
    }

    public void handlePercept(Agent agent, String perceptID, Object params) {
        EvacResident resident = (EvacResident)agent;
        if (perceptID.equals("FireAlert") && !resident.fireResponse) {
            resident.log("received alert " + params);
            resident.postEvacAlert("fire started");
            resident.fireResponse = true;
        } else if (perceptID.equals("leave now")) {
            resident.log("recieved percept to leave now at time " + GlobalTime.time.getTime());
            resident.postLeaveGoal();
            resident.waitAtHomeFlag = false;
        } else if (perceptID.equals("Arrived")) {
            Object[] args = (Object[])params;
            resident.log("reached " + args[0] + " at time " + args[1]);
        } else if (perceptID.equals("Arrived to connect to")) {
            Object[] args = (Object[])params;
            resident.log("arrived at conection link " + args[0] + " at time " + args[1]);
        } else if (perceptID.equals("arrived and picked up")) {
            resident.log("arrived and picked up from link " + ((Object[])params)[0]);
        } else if (perceptID.equals("picked up")) {
            resident.log("picked up " + params);
        }
    }

    public double getSimTime() {
        return 0.0;
    }

    public void updateAction(Agent agent, String actionID, ActionContent.State state, Object[] parameters) {
        try {
            this.logger.debug("scenarioTWO-update action: actionID {} state {}", (Object)actionID, (Object)state.toString());
            String returnedState = state.toString();
            String passed = ActionContent.State.PASSED.toString();
            if (actionID.equals("drive to") || actionID.equals("connect to") || actionID.equals("drive to and pick up")) {
                if (returnedState.compareTo(passed) == 0 && actionID.equals(((EvacResident)agent).initiatedAction)) {
                    ((EvacResident)agent).updateCurrentLocation();
                    ((EvacResident)agent).removeTargetDestination();
                } else {
                    ((EvacResident)agent).removeTargetDestination();
                }
            }
            ((EvacResident)agent).updateActionState(actionID, state, parameters);
        }
        catch (NumberFormatException e) {
            this.logger.debug("NumberFormatException : {}", (Object)e.getMessage());
        }
    }

    public EvacResident getBDICounterpart(String id) {
        if (this.agents.containsKey(id)) {
            return (EvacResident)((Object)this.agents.get(id));
        }
        return null;
    }
}

