/*
 * Decompiled with CFR 0.152.
 */
package com.melody.map.tencent_compose;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.compose.runtime.AbstractApplier;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.ComposeView;
import com.melody.map.tencent_compose.MapApplierKt;
import com.melody.map.tencent_compose.MapNode;
import com.melody.map.tencent_compose.MapNodeRoot;
import com.melody.map.tencent_compose.adapter.ComposeInfoWindowAdapter;
import com.melody.map.tencent_compose.overlay.DragState;
import com.melody.map.tencent_compose.overlay.MarkerNode;
import com.melody.map.tencent_compose.overlay.MarkerState;
import com.tencent.tencentmap.mapsdk.maps.MapView;
import com.tencent.tencentmap.mapsdk.maps.TencentMap;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.Marker;
import com.tencent.tencentmap.mapsdk.maps.model.Polygon;
import com.tencent.tencentmap.mapsdk.maps.model.Polyline;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/melody/map/tencent_compose/MapApplier;", "Landroidx/compose/runtime/AbstractApplier;", "Lcom/melody/map/tencent_compose/MapNode;", "map", "Lcom/tencent/tencentmap/mapsdk/maps/TencentMap;", "mapView", "Lcom/tencent/tencentmap/mapsdk/maps/MapView;", "<init>", "(Lcom/tencent/tencentmap/mapsdk/maps/TencentMap;Lcom/tencent/tencentmap/mapsdk/maps/MapView;)V", "getMap", "()Lcom/tencent/tencentmap/mapsdk/maps/TencentMap;", "getMapView", "()Lcom/tencent/tencentmap/mapsdk/maps/MapView;", "decorations", "", "mClusterInfoWindowView", "Landroidx/compose/ui/platform/ComposeView;", "getMClusterInfoWindowView$tencent_map_compose_release", "()Landroidx/compose/ui/platform/ComposeView;", "onClear", "", "insertBottomUp", "index", "", "instance", "insertTopDown", "move", "from", "to", "count", "remove", "attachClickListeners", "tencent-map-compose_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMapApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapApplier.kt\ncom/melody/map/tencent_compose/MapApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1863#2,2:175\n*S KotlinDebug\n*F\n+ 1 MapApplier.kt\ncom/melody/map/tencent_compose/MapApplier\n*L\n76#1:175,2\n*E\n"})
public final class MapApplier
extends AbstractApplier<MapNode> {
    @NotNull
    private final TencentMap map;
    @NotNull
    private final MapView mapView;
    @NotNull
    private final List<MapNode> decorations;
    public static final int $stable = 8;

    public MapApplier(@NotNull TencentMap map, @NotNull MapView mapView) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        super((Object)MapNodeRoot.INSTANCE);
        this.map = map;
        this.mapView = mapView;
        this.decorations = new ArrayList();
        this.attachClickListeners();
    }

    @NotNull
    public final TencentMap getMap() {
        return this.map;
    }

    @NotNull
    public final MapView getMapView() {
        return this.mapView;
    }

    @NotNull
    public final ComposeView getMClusterInfoWindowView$tencent_map_compose_release() {
        ComposeView composeView;
        Context context = this.mapView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        ComposeView $this$_get_mClusterInfoWindowView__u24lambda_u240 = composeView = new ComposeView(context, null, 0, 6, null);
        boolean bl = false;
        this.mapView.addView((View)$this$_get_mClusterInfoWindowView__u24lambda_u240, new ViewGroup.LayoutParams(-2, -2));
        return composeView;
    }

    protected void onClear() {
        this.map.clearAllOverlays();
        Iterable $this$forEach$iv = this.decorations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MapNode it = (MapNode)element$iv;
            boolean bl = false;
            it.onCleared();
        }
        this.decorations.clear();
    }

    public void insertBottomUp(int index, @NotNull MapNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.decorations.add(index, instance);
        instance.onAttached();
    }

    public void insertTopDown(int index, @NotNull MapNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
    }

    public void move(int from, int to, int count) {
        this.move(this.decorations, from, to, count);
    }

    public void remove(int index, int count) {
        int n = 0;
        while (n < count) {
            int it = n++;
            boolean bl = false;
            this.decorations.get(index + it).onRemoved();
        }
        this.remove(this.decorations, index, count);
    }

    private final void attachClickListeners() {
        this.map.setOnMarkerClickListener(arg_0 -> MapApplier.attachClickListeners$lambda$3(this, arg_0));
        this.map.setOnPolylineClickListener((arg_0, arg_1) -> MapApplier.attachClickListeners$lambda$4(this, arg_0, arg_1));
        this.map.setOnInfoWindowClickListener(new TencentMap.OnInfoWindowClickListener(this){
            final /* synthetic */ MapApplier this$0;
            {
                this.this$0 = $receiver;
            }

            public void onInfoWindowClick(Marker marker) {
                block0: {
                    Function1<Marker, Unit> function1;
                    if (marker == null || (function1 = MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), marker)) == null || (function1 = function1.getOnInfoWindowClick()) == null) break block0;
                    function1.invoke((Object)marker);
                }
            }

            public void onInfoWindowClickLocation(int p0, int p1, int p2, int p3) {
            }
        });
        this.map.setOnPolygonClickListener((arg_0, arg_1) -> MapApplier.attachClickListeners$lambda$5(this, arg_0, arg_1));
        this.map.setOnMarkerDragListener(new TencentMap.OnMarkerDragListener(this){
            final /* synthetic */ MapApplier this$0;
            {
                this.this$0 = $receiver;
            }

            public void onMarkerDrag(Marker marker) {
                block1: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    MarkerNode $this$onMarkerDrag_u24lambda_u240 = MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), marker);
                    boolean bl = false;
                    Object object2 = $this$onMarkerDrag_u24lambda_u240;
                    if (object2 != null && (object2 = ((MarkerNode)object2).getMarkerState()) != null) {
                        ((MarkerState)object2).setPosition(marker.getPosition());
                    }
                    if ((object = $this$onMarkerDrag_u24lambda_u240) == null || (object = ((MarkerNode)object).getMarkerState()) == null) break block1;
                    ((MarkerState)object).setDragState$tencent_map_compose_release(DragState.DRAG);
                }
            }

            public void onMarkerDragEnd(Marker marker) {
                block1: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    MarkerNode $this$onMarkerDragEnd_u24lambda_u241 = MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), marker);
                    boolean bl = false;
                    Object object2 = $this$onMarkerDragEnd_u24lambda_u241;
                    if (object2 != null && (object2 = ((MarkerNode)object2).getMarkerState()) != null) {
                        ((MarkerState)object2).setPosition(marker.getPosition());
                    }
                    if ((object = $this$onMarkerDragEnd_u24lambda_u241) == null || (object = ((MarkerNode)object).getMarkerState()) == null) break block1;
                    ((MarkerState)object).setDragState$tencent_map_compose_release(DragState.END);
                }
            }

            public void onMarkerDragStart(Marker marker) {
                block1: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    MarkerNode $this$onMarkerDragStart_u24lambda_u242 = MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), marker);
                    boolean bl = false;
                    Object object2 = $this$onMarkerDragStart_u24lambda_u242;
                    if (object2 != null && (object2 = ((MarkerNode)object2).getMarkerState()) != null) {
                        ((MarkerState)object2).setPosition(marker.getPosition());
                    }
                    if ((object = $this$onMarkerDragStart_u24lambda_u242) == null || (object = ((MarkerNode)object).getMarkerState()) == null) break block1;
                    ((MarkerState)object).setDragState$tencent_map_compose_release(DragState.START);
                }
            }
        });
        this.map.setInfoWindowAdapter((TencentMap.InfoWindowAdapter)new ComposeInfoWindowAdapter(this.mapView, (Function1<? super Marker, MarkerNode>)((Function1)arg_0 -> MapApplier.attachClickListeners$lambda$6(this, arg_0))));
    }

    private static final boolean attachClickListeners$lambda$3(MapApplier this$0, Marker marker) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        List<MapNode> list = this$0.decorations;
        Intrinsics.checkNotNull((Object)marker);
        Function1<Marker, Boolean> function1 = MapApplierKt.access$nodeForMarker(list, marker);
        return function1 != null && (function1 = function1.getOnMarkerClick()) != null ? (Boolean)function1.invoke((Object)marker) : false;
    }

    private static final void attachClickListeners$lambda$4(MapApplier this$0, Polyline polyline, LatLng latLng) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            List<MapNode> list = this$0.decorations;
            Intrinsics.checkNotNull((Object)polyline);
            Function1<Polyline, Unit> function1 = MapApplierKt.access$nodeForPolyline(list, polyline);
            if (function1 == null || (function1 = function1.getOnPolylineClick()) == null) break block0;
            function1.invoke((Object)polyline);
        }
    }

    private static final void attachClickListeners$lambda$5(MapApplier this$0, Polygon polygon, LatLng latLng) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            List<MapNode> list = this$0.decorations;
            Intrinsics.checkNotNull((Object)polygon);
            Function1<Polygon, Unit> function1 = MapApplierKt.access$nodeForPolygon(list, polygon);
            if (function1 == null || (function1 = function1.getOnClick()) == null) break block0;
            function1.invoke((Object)polygon);
        }
    }

    private static final MarkerNode attachClickListeners$lambda$6(MapApplier this$0, Marker it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MapApplierKt.access$nodeForMarker(this$0.decorations, it);
    }

    public static final /* synthetic */ List access$getDecorations$p(MapApplier $this) {
        return $this.decorations;
    }
}

