/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 **\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001*B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J$\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0087\u0002\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0004J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u001b\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004J\u0015\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010&\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020\u0017J\u001b\u0010)\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroid/support/v4/util/LongSparseArray;", "E", "", "initialCapacity", "", "<init>", "(I)V", "mGarbage", "", "mKeys", "", "mValues", "", "", "[Ljava/lang/Object;", "mSize", "clone", "get", "key", "", "valueIfKeyNotFound", "(JLjava/lang/Object;)Ljava/lang/Object;", "delete", "", "remove", "removeAt", "index", "gc", "put", "value", "(JLjava/lang/Object;)V", "size", "keyAt", "valueAt", "(I)Ljava/lang/Object;", "setValueAt", "(ILjava/lang/Object;)V", "indexOfKey", "indexOfValue", "(Ljava/lang/Object;)I", "clear", "append", "Companion", "tencent-map-compose_release"})
@StabilityInferred(parameters=0)
public final class LongSparseArray<E>
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean mGarbage;
    @NotNull
    private long[] mKeys;
    @NotNull
    private Object[] mValues;
    private int mSize;
    public static final int $stable = 8;
    @NotNull
    private static final Object DELETED = new Object();

    @JvmOverloads
    public LongSparseArray(int initialCapacity) {
        int newInitialCapacity = initialCapacity;
        newInitialCapacity = Companion.idealLongArraySize(newInitialCapacity);
        this.mKeys = new long[newInitialCapacity];
        this.mValues = new Object[newInitialCapacity];
        this.mSize = 0;
    }

    public /* synthetic */ LongSparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @NotNull
    public LongSparseArray<E> clone() {
        LongSparseArray clone = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.support.v4.util.LongSparseArray<E of android.support.v4.util.LongSparseArray>");
            clone = (LongSparseArray)object;
            clone.mKeys = (long[])this.mKeys.clone();
            clone.mValues = (Object[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        LongSparseArray longSparseArray = clone;
        Intrinsics.checkNotNull(longSparseArray);
        return longSparseArray;
    }

    @JvmOverloads
    @Nullable
    public final E get(long key, @Nullable E valueIfKeyNotFound) {
        int i = LongSparseArray.Companion.binarySearch(this.mKeys, 0, this.mSize, key);
        return (E)(i < 0 || this.mValues[i] == DELETED ? valueIfKeyNotFound : this.mValues[i]);
    }

    public static /* synthetic */ Object get$default(LongSparseArray longSparseArray, long l, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return longSparseArray.get(l, object);
    }

    public final void delete(long key) {
        int i = LongSparseArray.Companion.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    public final void remove(long key) {
        this.delete(key);
    }

    public final void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    private final void gc() {
        int n = this.mSize;
        int o = 0;
        long[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object val = values[i];
            if (val == DELETED) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
                values[i] = null;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    public final void put(long key, E value) {
        int i = LongSparseArray.Companion.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
                this.mKeys[i] = key;
                this.mValues[i] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i = ~LongSparseArray.Companion.binarySearch(this.mKeys, 0, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n = Companion.idealLongArraySize(this.mSize + 1);
                long[] nkeys = new long[n];
                Object[] nvalues = new Object[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = value;
            int n = this.mSize;
            this.mSize = n + 1;
        }
    }

    public final int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public final long keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    @Nullable
    public final E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public final void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public final int indexOfKey(long key) {
        if (this.mGarbage) {
            this.gc();
        }
        return LongSparseArray.Companion.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public final int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public final void clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public final void append(long key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n = Companion.idealLongArraySize(pos + 1);
            long[] nkeys = new long[n];
            Object[] nvalues = new Object[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    @JvmOverloads
    public LongSparseArray() {
        this(0, 1, null);
    }

    @JvmOverloads
    @Nullable
    public final E get(long key) {
        return (E)LongSparseArray.get$default(this, key, null, 2, null);
    }

    @JvmStatic
    public static final int idealByteArraySize(int need) {
        return Companion.idealByteArraySize(need);
    }

    @JvmStatic
    public static final int idealLongArraySize(int need) {
        return Companion.idealLongArraySize(need);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0007R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroid/support/v4/util/LongSparseArray$Companion;", "", "<init>", "()V", "DELETED", "binarySearch", "", "a", "", "start", "len", "key", "", "idealByteArraySize", "need", "idealLongArraySize", "tencent-map-compose_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int binarySearch(long[] a, int start, int len, long key) {
            int high = start + len;
            int low = start - 1;
            int guess = 0;
            while (high - low > 1) {
                guess = (high + low) / 2;
                if (a[guess] < key) {
                    low = guess;
                    continue;
                }
                high = guess;
            }
            return high == start + len ? ~(start + len) : (a[high] == key ? high : ~high);
        }

        @JvmStatic
        public final int idealByteArraySize(int need) {
            for (int i = 4; i < 32; ++i) {
                if (need > (1 << i) - 12) continue;
                return (1 << i) - 12;
            }
            return need;
        }

        @JvmStatic
        public final int idealLongArraySize(int need) {
            return this.idealByteArraySize(need * 8) / 8;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

