/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.oracle;

import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;

final class OracleAnsiSqlRowsLimiter
implements SqlLimiter {
    OracleAnsiSqlRowsLimiter() {
    }

    public SqlLimitResponse limit(SqlLimitRequest request) {
        int maxRows;
        String dbSql = request.getDbSql();
        StringBuilder sb = new StringBuilder(50 + dbSql.length());
        sb.append("select ");
        if (request.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(dbSql);
        int firstRow = request.getFirstRow();
        if (firstRow > 0) {
            sb.append(" offset ").append(firstRow).append(" rows");
        }
        if ((maxRows = request.getMaxRows()) > 0) {
            sb.append(" fetch next ").append(maxRows).append(" rows only");
        }
        return new SqlLimitResponse(sb.toString());
    }
}

