/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.oracle;

import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DatabasePlatformProvider;
import io.ebean.platform.oracle.Oracle11Platform;
import io.ebean.platform.oracle.Oracle12Platform;
import io.ebean.platform.oracle.OraclePlatform;
import java.sql.Connection;
import java.sql.DatabaseMetaData;

public class OraclePlatformProvider
implements DatabasePlatformProvider {
    public String toString() {
        return "Oracle";
    }

    public boolean match(String name) {
        return name.startsWith("oracle");
    }

    public DatabasePlatform create(String name) {
        if (name.equals("oracle11") || name.equals("oracle10") || name.equals("oracle9")) {
            return new Oracle11Platform();
        }
        if (name.equals("oracle12")) {
            return new Oracle12Platform();
        }
        return new OraclePlatform();
    }

    public boolean matchByProductName(String productName) {
        return productName.contains("oracle");
    }

    public DatabasePlatform create(int majorVersion, int minorVersion, DatabaseMetaData meta, Connection connection) {
        if (majorVersion < 12) {
            return new Oracle11Platform();
        }
        if (majorVersion < 13) {
            return new Oracle12Platform();
        }
        return new OraclePlatform();
    }

    public boolean matchPlatform(Platform platform) {
        return Platform.ORACLE.equals((Object)platform.base());
    }

    public DatabasePlatform create(Platform platform) {
        if (platform.equals((Object)Platform.ORACLE11)) {
            return new Oracle11Platform();
        }
        if (platform.equals((Object)Platform.ORACLE12)) {
            return new Oracle12Platform();
        }
        return new OraclePlatform();
    }
}

