/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration
implements Comparable<Duration>,
Serializable {
    private static final long serialVersionUID = 1445611723318059801L;
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)\\s*(\\S+)");
    private static final Map<String, TimeUnit> SUFFIXES = Map.ofEntries(Map.entry("ns", TimeUnit.NANOSECONDS), Map.entry("nanosecond", TimeUnit.NANOSECONDS), Map.entry("nanoseconds", TimeUnit.NANOSECONDS), Map.entry("us", TimeUnit.MICROSECONDS), Map.entry("microsecond", TimeUnit.MICROSECONDS), Map.entry("microseconds", TimeUnit.MICROSECONDS), Map.entry("ms", TimeUnit.MILLISECONDS), Map.entry("millisecond", TimeUnit.MILLISECONDS), Map.entry("milliseconds", TimeUnit.MILLISECONDS), Map.entry("s", TimeUnit.SECONDS), Map.entry("second", TimeUnit.SECONDS), Map.entry("seconds", TimeUnit.SECONDS), Map.entry("m", TimeUnit.MINUTES), Map.entry("min", TimeUnit.MINUTES), Map.entry("mins", TimeUnit.MINUTES), Map.entry("minute", TimeUnit.MINUTES), Map.entry("minutes", TimeUnit.MINUTES), Map.entry("h", TimeUnit.HOURS), Map.entry("hour", TimeUnit.HOURS), Map.entry("hours", TimeUnit.HOURS), Map.entry("d", TimeUnit.DAYS), Map.entry("day", TimeUnit.DAYS), Map.entry("days", TimeUnit.DAYS));
    private final long count;
    private final TimeUnit unit;

    public static Duration nanoseconds(long count) {
        return new Duration(count, TimeUnit.NANOSECONDS);
    }

    public static Duration microseconds(long count) {
        return new Duration(count, TimeUnit.MICROSECONDS);
    }

    public static Duration milliseconds(long count) {
        return new Duration(count, TimeUnit.MILLISECONDS);
    }

    public static Duration seconds(long count) {
        return new Duration(count, TimeUnit.SECONDS);
    }

    public static Duration minutes(long count) {
        return new Duration(count, TimeUnit.MINUTES);
    }

    public static Duration hours(long count) {
        return new Duration(count, TimeUnit.HOURS);
    }

    public static Duration days(long count) {
        return new Duration(count, TimeUnit.DAYS);
    }

    @JsonCreator
    public static Duration parse(String duration) {
        Matcher matcher = DURATION_PATTERN.matcher(duration);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid duration: " + duration);
        }
        long count = Long.parseLong(matcher.group(1));
        TimeUnit unit = SUFFIXES.get(matcher.group(2));
        if (unit == null) {
            throw new IllegalArgumentException("Invalid duration: " + duration + ". Wrong time unit");
        }
        return new Duration(count, unit);
    }

    private Duration(long count, TimeUnit unit) {
        this.count = count;
        this.unit = Objects.requireNonNull(unit);
    }

    public long getQuantity() {
        return this.count;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long toNanoseconds() {
        return TimeUnit.NANOSECONDS.convert(this.count, this.unit);
    }

    public long toMicroseconds() {
        return TimeUnit.MICROSECONDS.convert(this.count, this.unit);
    }

    public long toMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.count, this.unit);
    }

    public long toSeconds() {
        return TimeUnit.SECONDS.convert(this.count, this.unit);
    }

    public long toMinutes() {
        return TimeUnit.MINUTES.convert(this.count, this.unit);
    }

    public long toHours() {
        return TimeUnit.HOURS.convert(this.count, this.unit);
    }

    public long toDays() {
        return TimeUnit.DAYS.convert(this.count, this.unit);
    }

    public java.time.Duration toJavaDuration() {
        return java.time.Duration.ofNanos(this.toNanoseconds());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Duration duration = (Duration)obj;
        return this.count == duration.count && this.unit == duration.unit;
    }

    public int hashCode() {
        return 31 * (int)(this.count ^ this.count >>> 32) + this.unit.hashCode();
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase(Locale.ENGLISH);
        if (this.count == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.count) + " " + units;
    }

    @Override
    public int compareTo(Duration other) {
        if (this.unit == other.unit) {
            return Long.compare(this.count, other.count);
        }
        return Long.compare(this.toNanoseconds(), other.toNanoseconds());
    }
}

