/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.tasks;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import io.dropwizard.servlets.tasks.Task;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogConfigurationTask
extends Task {
    private final ILoggerFactory loggerContext;

    public LogConfigurationTask() {
        this(LoggerFactory.getILoggerFactory());
    }

    public LogConfigurationTask(ILoggerFactory loggerContext) {
        super("log-level");
        this.loggerContext = loggerContext;
    }

    @Override
    public void execute(ImmutableMultimap<String, String> parameters, PrintWriter output) throws Exception {
        List<String> loggerNames = this.getLoggerNames(parameters);
        Level loggerLevel = this.getLoggerLevel(parameters);
        for (String loggerName : loggerNames) {
            ((LoggerContext)this.loggerContext).getLogger(loggerName).setLevel(loggerLevel);
            output.println(String.format("Configured logging level for %s to %s", loggerName, loggerLevel));
            output.flush();
        }
    }

    private List<String> getLoggerNames(ImmutableMultimap<String, String> parameters) {
        return parameters.get((Object)"logger").asList();
    }

    @Nullable
    private Level getLoggerLevel(ImmutableMultimap<String, String> parameters) {
        ImmutableList loggerLevels = parameters.get((Object)"level").asList();
        return loggerLevels.isEmpty() ? null : Level.valueOf((String)((String)loggerLevels.get(0)));
    }
}

