/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.tasks;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import io.dropwizard.servlets.tasks.Task;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServlet
extends HttpServlet {
    private static final long serialVersionUID = 7404713218661358124L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServlet.class);
    private final ConcurrentMap<String, Task> tasks;
    private final ConcurrentMap<Task, TaskExecutor> taskExecutors;
    private final MetricRegistry metricRegistry;

    public TaskServlet(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.tasks = Maps.newConcurrentMap();
        this.taskExecutors = Maps.newConcurrentMap();
    }

    public void add(Task task) {
        this.tasks.put('/' + task.getName(), task);
        TaskExecutor taskExecutor = new TaskExecutor(task);
        try {
            String name;
            Timed annotation;
            Method executeMethod = task.getClass().getMethod("execute", ImmutableMultimap.class, PrintWriter.class);
            if (executeMethod.isAnnotationPresent(Timed.class)) {
                annotation = executeMethod.getAnnotation(Timed.class);
                name = this.chooseName(annotation.name(), annotation.absolute(), task, new String[0]);
                Timer timer = this.metricRegistry.timer(name);
                taskExecutor = new TimedTask(taskExecutor, timer);
            }
            if (executeMethod.isAnnotationPresent(Metered.class)) {
                annotation = executeMethod.getAnnotation(Metered.class);
                name = this.chooseName(annotation.name(), annotation.absolute(), task, new String[0]);
                Meter meter = this.metricRegistry.meter(name);
                taskExecutor = new MeteredTask(taskExecutor, meter);
            }
            if (executeMethod.isAnnotationPresent(ExceptionMetered.class)) {
                annotation = executeMethod.getAnnotation(ExceptionMetered.class);
                name = this.chooseName(annotation.name(), annotation.absolute(), task, "exceptions");
                Meter exceptionMeter = this.metricRegistry.meter(name);
                taskExecutor = new ExceptionMeteredTask(taskExecutor, exceptionMeter, annotation.cause());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.taskExecutors.put(task, taskExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Task task = (Task)this.tasks.get(req.getPathInfo());
        if (task != null) {
            resp.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
            try (PrintWriter output = resp.getWriter();){
                TaskExecutor taskExecutor = (TaskExecutor)this.taskExecutors.get(task);
                taskExecutor.executeTask(TaskServlet.getParams(req), output);
            }
        } else {
            resp.sendError(404);
        }
    }

    private static ImmutableMultimap<String, String> getParams(HttpServletRequest req) {
        ImmutableMultimap.Builder results = ImmutableMultimap.builder();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object[] values = req.getParameterValues(name);
            results.putAll((Object)name, values);
        }
        return results.build();
    }

    public Collection<Task> getTasks() {
        return this.tasks.values();
    }

    private String chooseName(String explicitName, boolean absolute, Task task, String ... suffixes) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricRegistry.name(task.getClass(), (String[])new String[]{explicitName});
        }
        return MetricRegistry.name(task.getClass(), (String[])suffixes);
    }

    private static class ExceptionMeteredTask
    extends TaskExecutor {
        private TaskExecutor underlying;
        private final Meter exceptionMeter;
        private final Class<?> exceptionClass;

        private ExceptionMeteredTask(TaskExecutor underlying, Meter exceptionMeter, Class<? extends Throwable> exceptionClass) {
            super(underlying.task);
            this.underlying = underlying;
            this.exceptionMeter = exceptionMeter;
            this.exceptionClass = exceptionClass;
        }

        @Override
        public void executeTask(ImmutableMultimap<String, String> params, PrintWriter output) throws Exception {
            try {
                this.underlying.executeTask(params, output);
            }
            catch (Exception e) {
                if (this.exceptionMeter != null && this.exceptionClass.isAssignableFrom(e.getClass()) || e.getCause() != null && this.exceptionClass.isAssignableFrom(e.getCause().getClass())) {
                    this.exceptionMeter.mark();
                }
                throw e;
            }
        }
    }

    private static class MeteredTask
    extends TaskExecutor {
        private TaskExecutor underlying;
        private final Meter meter;

        private MeteredTask(TaskExecutor underlying, Meter meter) {
            super(underlying.task);
            this.meter = meter;
            this.underlying = underlying;
        }

        @Override
        public void executeTask(ImmutableMultimap<String, String> params, PrintWriter output) throws Exception {
            this.meter.mark();
            this.underlying.executeTask(params, output);
        }
    }

    private static class TimedTask
    extends TaskExecutor {
        private TaskExecutor underlying;
        private final Timer timer;

        private TimedTask(TaskExecutor underlying, Timer timer) {
            super(underlying.task);
            this.underlying = underlying;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeTask(ImmutableMultimap<String, String> params, PrintWriter output) throws Exception {
            Timer.Context context = this.timer.time();
            try {
                this.underlying.executeTask(params, output);
            }
            finally {
                context.stop();
            }
        }
    }

    private static class TaskExecutor {
        private final Task task;

        private TaskExecutor(Task task) {
            this.task = task;
        }

        public void executeTask(ImmutableMultimap<String, String> params, PrintWriter output) throws Exception {
            this.task.execute(params, output);
        }
    }
}

