/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.spi.ServerAdapter;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

class DropwizardJettyServerAdapter
implements ServerAdapter {
    private final Request request;
    private final Response response;

    public DropwizardJettyServerAdapter(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public long getRequestTimestamp() {
        return this.request.getTimeStamp();
    }

    public long getContentLength() {
        return this.response.getHttpChannel().getBytesWritten();
    }

    public int getStatusCode() {
        return this.response.getCommittedMetaData().getStatus();
    }

    public Map<String, String> buildResponseHeaderMap() {
        return this.response.getHttpFields().stream().collect(Collectors.toMap(HttpField::getName, HttpField::getValue));
    }
}

