/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.common;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.metrics.common.ReporterFactory;
import io.dropwizard.metrics.common.ScheduledReporterManager;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsFactory.class);
    @Valid
    @NotNull
    private Duration frequency = Duration.minutes((long)1L);
    @Valid
    @NotNull
    private List<ReporterFactory> reporters = Collections.emptyList();
    private boolean reportOnStop = false;

    @JsonProperty
    public List<ReporterFactory> getReporters() {
        return this.reporters;
    }

    @JsonProperty
    public void setReporters(List<ReporterFactory> reporters) {
        this.reporters = new ArrayList<ReporterFactory>(reporters);
    }

    @JsonProperty
    public Duration getFrequency() {
        return this.frequency;
    }

    @JsonProperty
    public void setFrequency(Duration frequency) {
        this.frequency = frequency;
    }

    @JsonProperty
    public boolean isReportOnStop() {
        return this.reportOnStop;
    }

    @JsonProperty
    public void setReportOnStop(boolean reportOnStop) {
        this.reportOnStop = reportOnStop;
    }

    public void configure(LifecycleEnvironment environment, MetricRegistry registry) {
        for (ReporterFactory reporter : this.reporters) {
            try {
                ScheduledReporterManager manager = new ScheduledReporterManager(reporter.build(registry), reporter.getFrequency().orElseGet(this::getFrequency), this.isReportOnStop());
                environment.manage((Managed)manager);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create reporter, metrics may not be properly reported.", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "MetricsFactory{frequency=" + this.frequency + ", reporters=" + this.reporters + ", reportOnStop=" + this.reportOnStop + "}";
    }
}

