/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.util.StatusPrinter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.logback.InstrumentedAppender;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.logback.AsyncAppenderBaseProxy;
import io.dropwizard.logging.common.AppenderFactory;
import io.dropwizard.logging.common.ConsoleAppenderFactory;
import io.dropwizard.logging.common.DropwizardLayout;
import io.dropwizard.logging.common.LoggerConfiguration;
import io.dropwizard.logging.common.LoggingFactory;
import io.dropwizard.logging.common.LoggingUtil;
import io.dropwizard.logging.common.async.AsyncLoggingEventAppenderFactory;
import io.dropwizard.logging.common.filter.ThresholdLevelFilterFactory;
import io.dropwizard.logging.common.layout.DropwizardLayoutFactory;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonTypeName(value="default")
public class DefaultLoggingFactory
implements LoggingFactory {
    private static final ReentrantLock CHANGE_LOGGER_CONTEXT_LOCK = new ReentrantLock();
    @NotNull
    private String level = "INFO";
    @NotNull
    private Map<String, JsonNode> loggers = Collections.emptyMap();
    @Valid
    @NotNull
    private List<AppenderFactory<ILoggingEvent>> appenders = Collections.singletonList(new ConsoleAppenderFactory());
    @JsonIgnore
    private final LoggerContext loggerContext;
    @JsonIgnore
    private final PrintStream configurationErrorsStream;

    public DefaultLoggingFactory() {
        this(LoggingUtil.getLoggerContext(), System.err);
    }

    DefaultLoggingFactory(LoggerContext loggerContext, PrintStream configurationErrorsStream) {
        this.loggerContext = Objects.requireNonNull(loggerContext);
        this.configurationErrorsStream = Objects.requireNonNull(configurationErrorsStream);
    }

    LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    PrintStream getConfigurationErrorsStream() {
        return this.configurationErrorsStream;
    }

    @JsonProperty
    public String getLevel() {
        return this.level;
    }

    @JsonProperty
    public void setLevel(String level) {
        this.level = level;
    }

    @JsonProperty
    public Map<String, JsonNode> getLoggers() {
        return this.loggers;
    }

    @JsonProperty
    public void setLoggers(Map<String, JsonNode> loggers) {
        this.loggers = new HashMap<String, JsonNode>(loggers);
    }

    @JsonProperty
    public List<AppenderFactory<ILoggingEvent>> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(List<AppenderFactory<ILoggingEvent>> appenders) {
        this.appenders = new ArrayList<AppenderFactory<ILoggingEvent>>(appenders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(MetricRegistry metricRegistry, String name) {
        Logger root;
        LoggingUtil.hijackJDKLogging();
        CHANGE_LOGGER_CONTEXT_LOCK.lock();
        try {
            root = this.configureLoggers(name);
        }
        finally {
            CHANGE_LOGGER_CONTEXT_LOCK.unlock();
        }
        ThresholdLevelFilterFactory levelFilterFactory = new ThresholdLevelFilterFactory();
        AsyncLoggingEventAppenderFactory asyncAppenderFactory = new AsyncLoggingEventAppenderFactory();
        DropwizardLayoutFactory layoutFactory = new DropwizardLayoutFactory();
        for (AppenderFactory<ILoggingEvent> output : this.appenders) {
            root.addAppender(output.build(this.loggerContext, name, layoutFactory, levelFilterFactory, asyncAppenderFactory));
        }
        StatusPrinter.setPrintStream((PrintStream)this.configurationErrorsStream);
        try {
            StatusPrinter.printIfErrorsOccured((Context)this.loggerContext);
        }
        finally {
            StatusPrinter.setPrintStream((PrintStream)System.out);
        }
        this.configureInstrumentation(root, metricRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        CHANGE_LOGGER_CONTEXT_LOCK.lock();
        try {
            Logger logger = this.loggerContext.getLogger("ROOT");
            Iterator appenderIterator = logger.iteratorForAppenders();
            while (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                if (appender instanceof AsyncAppenderBase) {
                    AsyncAppenderBase asyncAppenderBase = (AsyncAppenderBase)appender;
                    this.flushAppender(asyncAppenderBase);
                    continue;
                }
                if (!(appender instanceof AsyncAppenderBaseProxy)) continue;
                AsyncAppenderBaseProxy asyncAppenderBaseProxy = (AsyncAppenderBaseProxy)appender;
                this.flushAppender(asyncAppenderBaseProxy.getAppender());
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            CHANGE_LOGGER_CONTEXT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        CHANGE_LOGGER_CONTEXT_LOCK.lock();
        try {
            this.loggerContext.stop();
            Logger logger = this.loggerContext.getLogger("ROOT");
            logger.detachAndStopAllAppenders();
            DropwizardLayout formatter = new DropwizardLayout(this.loggerContext, TimeZone.getDefault());
            formatter.start();
            LayoutWrappingEncoder layoutEncoder = new LayoutWrappingEncoder();
            layoutEncoder.setLayout((Layout)formatter);
            ConsoleAppender consoleAppender = new ConsoleAppender();
            consoleAppender.addFilter(new ThresholdLevelFilterFactory().build(Level.INFO));
            consoleAppender.setEncoder((Encoder)layoutEncoder);
            consoleAppender.setContext((Context)this.loggerContext);
            consoleAppender.start();
            logger.addAppender((Appender)consoleAppender);
            this.loggerContext.start();
        }
        finally {
            CHANGE_LOGGER_CONTEXT_LOCK.unlock();
        }
    }

    private void flushAppender(AsyncAppenderBase<?> appender) throws InterruptedException {
        for (int timeWaiting = 0; timeWaiting < appender.getMaxFlushTime() && appender.getNumberOfElementsInQueue() > 0; timeWaiting += 100) {
            Thread.sleep(100L);
        }
        if (appender.getNumberOfElementsInQueue() > 0) {
            appender.addWarn(appender.getNumberOfElementsInQueue() + " events may be discarded");
        }
    }

    private void configureInstrumentation(Logger root, MetricRegistry metricRegistry) {
        InstrumentedAppender appender = new InstrumentedAppender(metricRegistry);
        appender.setContext((Context)this.loggerContext);
        appender.start();
        root.addAppender((Appender)appender);
    }

    private Logger configureLoggers(String name) {
        Logger root = this.loggerContext.getLogger("ROOT");
        this.loggerContext.reset();
        LevelChangePropagator propagator = new LevelChangePropagator();
        propagator.setContext((Context)this.loggerContext);
        propagator.setResetJUL(true);
        this.loggerContext.addListener((LoggerContextListener)propagator);
        root.setLevel(DefaultLoggingFactory.toLevel(this.level));
        ThresholdLevelFilterFactory levelFilterFactory = new ThresholdLevelFilterFactory();
        AsyncLoggingEventAppenderFactory asyncAppenderFactory = new AsyncLoggingEventAppenderFactory();
        DropwizardLayoutFactory layoutFactory = new DropwizardLayoutFactory();
        ObjectMapper objectMapper = Jackson.newObjectMapper();
        for (Map.Entry<String, JsonNode> entry : this.loggers.entrySet()) {
            Logger logger = this.loggerContext.getLogger(entry.getKey());
            JsonNode jsonNode = entry.getValue();
            if (jsonNode.isTextual() || jsonNode.isBoolean()) {
                logger.setLevel(DefaultLoggingFactory.toLevel(jsonNode.asText()));
                continue;
            }
            if (jsonNode.isObject()) {
                LoggerConfiguration configuration;
                try {
                    configuration = (LoggerConfiguration)objectMapper.treeToValue((TreeNode)jsonNode, LoggerConfiguration.class);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Wrong format of logger '" + entry.getKey() + "'", e);
                }
                logger.setLevel(DefaultLoggingFactory.toLevel(configuration.getLevel()));
                logger.setAdditive(configuration.isAdditive());
                for (AppenderFactory<ILoggingEvent> appender : configuration.getAppenders()) {
                    logger.addAppender(appender.build(this.loggerContext, name, layoutFactory, levelFilterFactory, asyncAppenderFactory));
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported format of logger '" + entry.getKey() + "'");
        }
        return root;
    }

    static Level toLevel(@Nullable String text) {
        if ("false".equalsIgnoreCase(text)) {
            return Level.OFF;
        }
        if ("true".equalsIgnoreCase(text)) {
            return Level.ALL;
        }
        return Level.toLevel((String)text, (Level)Level.INFO);
    }

    public String toString() {
        return "DefaultLoggingFactory{level=" + this.level + ", loggers=" + this.loggers + ", appenders=" + this.appenders + "}";
    }
}

