/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.logback.ThrottlingAppenderWrapper;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.DefaultLoggingFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.FilterFactory;
import io.dropwizard.logging.layout.DiscoverableLayoutFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.util.Strings;
import io.dropwizard.validation.MaxDuration;
import io.dropwizard.validation.MinDuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public abstract class AbstractAppenderFactory<E extends DeferredProcessingAware>
implements AppenderFactory<E> {
    @NotNull
    protected Level threshold = Level.ALL;
    @Nullable
    protected String logFormat;
    @Nullable
    protected DiscoverableLayoutFactory<E> layout;
    @NotNull
    protected TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int queueSize = 256;
    private int discardingThreshold = -1;
    @Nullable
    @MinDuration(value=0L, unit=TimeUnit.SECONDS, inclusive=false)
    @MaxDuration(value=1L, unit=TimeUnit.MINUTES)
    private @MinDuration(value=0L, unit=TimeUnit.SECONDS, inclusive=false) @MaxDuration(value=1L, unit=TimeUnit.MINUTES) Duration messageRate;
    private boolean includeCallerData = false;
    private List<FilterFactory<E>> filterFactories = Collections.emptyList();
    private boolean neverBlock = false;

    @JsonProperty
    public int getQueueSize() {
        return this.queueSize;
    }

    @JsonProperty
    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    @JsonProperty
    public int getDiscardingThreshold() {
        return this.discardingThreshold;
    }

    @JsonProperty
    public void setDiscardingThreshold(int discardingThreshold) {
        this.discardingThreshold = discardingThreshold;
    }

    @JsonProperty
    @Nullable
    public Duration getMessageRate() {
        return this.messageRate;
    }

    @JsonProperty
    public void setMessageRate(Duration messageRate) {
        this.messageRate = messageRate;
    }

    @JsonProperty
    public String getThreshold() {
        return this.threshold.toString();
    }

    @JsonProperty
    public void setThreshold(String threshold) {
        this.threshold = DefaultLoggingFactory.toLevel(threshold);
    }

    @JsonProperty
    @Nullable
    public String getLogFormat() {
        return this.logFormat;
    }

    @JsonProperty
    public void setLogFormat(@Nullable String logFormat) {
        this.logFormat = logFormat;
    }

    @JsonProperty
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public void setTimeZone(String zoneId) {
        this.timeZone = Strings.nullToEmpty((String)zoneId).equalsIgnoreCase("system") ? TimeZone.getDefault() : TimeZone.getTimeZone(zoneId);
    }

    @JsonProperty
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty
    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    @JsonProperty
    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    @JsonProperty
    public List<FilterFactory<E>> getFilterFactories() {
        return this.filterFactories;
    }

    @JsonProperty
    public void setFilterFactories(List<FilterFactory<E>> appenders) {
        this.filterFactories = new ArrayList<FilterFactory<FilterFactory<E>>>(appenders);
    }

    @JsonProperty
    public void setNeverBlock(boolean neverBlock) {
        this.neverBlock = neverBlock;
    }

    @Nullable
    public DiscoverableLayoutFactory<?> getLayout() {
        return this.layout;
    }

    public void setLayout(@Nullable DiscoverableLayoutFactory<E> layout) {
        this.layout = layout;
    }

    protected Appender<E> wrapAsync(Appender<E> appender, AsyncAppenderFactory<E> asyncAppenderFactory) {
        return this.wrapAsync(appender, asyncAppenderFactory, appender.getContext());
    }

    protected Appender<E> wrapAsync(Appender<E> appender, AsyncAppenderFactory<E> asyncAppenderFactory, Context context) {
        AsyncAppenderBase<E> asyncAppender = asyncAppenderFactory.build();
        if (asyncAppender instanceof AsyncAppender) {
            ((AsyncAppender)asyncAppender).setIncludeCallerData(this.includeCallerData);
        }
        asyncAppender.setQueueSize(this.queueSize);
        asyncAppender.setDiscardingThreshold(this.discardingThreshold);
        asyncAppender.setContext(context);
        asyncAppender.setName("async-" + appender.getName());
        asyncAppender.addAppender(appender);
        asyncAppender.setNeverBlock(this.neverBlock);
        asyncAppender.start();
        if (this.messageRate == null) {
            return asyncAppender;
        }
        return new ThrottlingAppenderWrapper(asyncAppender, this.messageRate.getQuantity(), this.messageRate.getUnit());
    }

    protected LayoutBase<E> buildLayout(LoggerContext context, LayoutFactory<E> defaultLayoutFactory) {
        LayoutBase<E> layoutBase;
        if (this.layout == null) {
            PatternLayoutBase<E> patternLayoutBase = defaultLayoutFactory.build(context, this.timeZone);
            if (!Strings.isNullOrEmpty((String)this.logFormat)) {
                patternLayoutBase.setPattern(this.logFormat);
            }
            layoutBase = patternLayoutBase;
        } else {
            layoutBase = this.layout.build(context, this.timeZone);
        }
        layoutBase.start();
        return layoutBase;
    }
}

