/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.logging.json.layout.JsonFormatter;
import io.dropwizard.logging.json.layout.TimestampFormatter;
import io.dropwizard.logging.layout.DiscoverableLayoutFactory;
import java.util.Collections;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public abstract class AbstractJsonLayoutBaseFactory<E extends DeferredProcessingAware>
implements DiscoverableLayoutFactory<E> {
    @Nullable
    private String timestampFormat;
    private boolean prettyPrint;
    private boolean appendLineSeparator = true;
    @NotNull
    private Map<String, String> customFieldNames = Collections.emptyMap();
    @NotNull
    private Map<String, Object> additionalFields = Collections.emptyMap();

    @JsonProperty
    @Nullable
    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    @JsonProperty
    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    @JsonProperty
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @JsonProperty
    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @JsonProperty
    public boolean isAppendLineSeparator() {
        return this.appendLineSeparator;
    }

    @JsonProperty
    public void setAppendLineSeparator(boolean appendLineSeparator) {
        this.appendLineSeparator = appendLineSeparator;
    }

    @JsonProperty
    public Map<String, String> getCustomFieldNames() {
        return this.customFieldNames;
    }

    @JsonProperty
    public void setCustomFieldNames(Map<String, String> customFieldNames) {
        this.customFieldNames = customFieldNames;
    }

    @JsonProperty
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonProperty
    public void setAdditionalFields(Map<String, Object> additionalFields) {
        this.additionalFields = additionalFields;
    }

    protected JsonFormatter createDropwizardJsonFormatter() {
        return new JsonFormatter(Jackson.newObjectMapper(), this.isPrettyPrint(), this.isAppendLineSeparator());
    }

    protected TimestampFormatter createTimestampFormatter(TimeZone timeZone) {
        return new TimestampFormatter(this.getTimestampFormat(), timeZone.toZoneId());
    }
}

