/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class TimestampFormatter {
    private static final Map<String, DateTimeFormatter> FORMATTERS = ImmutableMap.builder().put((Object)"ISO_LOCAL_DATE", (Object)DateTimeFormatter.ISO_LOCAL_DATE).put((Object)"ISO_OFFSET_DATE", (Object)DateTimeFormatter.ISO_OFFSET_DATE).put((Object)"ISO_DATE", (Object)DateTimeFormatter.ISO_DATE).put((Object)"ISO_LOCAL_TIME", (Object)DateTimeFormatter.ISO_LOCAL_TIME).put((Object)"ISO_OFFSET_TIME", (Object)DateTimeFormatter.ISO_OFFSET_TIME).put((Object)"ISO_TIME", (Object)DateTimeFormatter.ISO_TIME).put((Object)"ISO_LOCAL_DATE_TIME", (Object)DateTimeFormatter.ISO_LOCAL_DATE_TIME).put((Object)"ISO_OFFSET_DATE_TIME", (Object)DateTimeFormatter.ISO_OFFSET_DATE_TIME).put((Object)"ISO_ZONED_DATE_TIME", (Object)DateTimeFormatter.ISO_ZONED_DATE_TIME).put((Object)"ISO_DATE_TIME", (Object)DateTimeFormatter.ISO_DATE_TIME).put((Object)"ISO_ORDINAL_DATE", (Object)DateTimeFormatter.ISO_ORDINAL_DATE).put((Object)"ISO_WEEK_DATE", (Object)DateTimeFormatter.ISO_WEEK_DATE).put((Object)"ISO_INSTANT", (Object)DateTimeFormatter.ISO_INSTANT).put((Object)"BASIC_ISO_DATE", (Object)DateTimeFormatter.BASIC_ISO_DATE).put((Object)"RFC_1123_DATE_TIME", (Object)DateTimeFormatter.RFC_1123_DATE_TIME).build();
    @Nullable
    private final DateTimeFormatter dateTimeFormatter;

    public TimestampFormatter(@Nullable String timestampFormat, ZoneId zoneId) {
        this.dateTimeFormatter = timestampFormat != null ? Optional.ofNullable(FORMATTERS.get(timestampFormat)).orElseGet(() -> DateTimeFormatter.ofPattern(timestampFormat)).withZone(zoneId) : null;
    }

    public Object format(long timestamp) {
        return this.dateTimeFormatter == null ? Long.valueOf(timestamp) : this.dateTimeFormatter.format(Instant.ofEpochMilli(timestamp));
    }
}

