/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import ch.qos.logback.access.spi.IAccessEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import io.dropwizard.logging.json.AccessAttribute;
import io.dropwizard.logging.json.layout.AbstractJsonLayout;
import io.dropwizard.logging.json.layout.JsonFormatter;
import io.dropwizard.logging.json.layout.MapBuilder;
import io.dropwizard.logging.json.layout.TimestampFormatter;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AccessJsonLayout
extends AbstractJsonLayout<IAccessEvent> {
    private ImmutableSet<AccessAttribute> includes;
    private ImmutableSet<String> requestHeaders = ImmutableSortedSet.of();
    private ImmutableSet<String> responseHeaders = ImmutableSortedSet.of();
    @Nullable
    private String jsonProtocolVersion;
    private final TimestampFormatter timestampFormatter;
    private final Map<String, Object> additionalFields;
    private final Map<String, String> customFieldNames;

    public AccessJsonLayout(JsonFormatter jsonFormatter, TimestampFormatter timestampFormatter, Set<AccessAttribute> includes, Map<String, String> customFieldNames, Map<String, Object> additionalFields) {
        super(jsonFormatter);
        this.timestampFormatter = timestampFormatter;
        this.additionalFields = ImmutableMap.copyOf(additionalFields);
        this.customFieldNames = ImmutableMap.copyOf(customFieldNames);
        this.includes = Sets.immutableEnumSet(includes);
    }

    @Override
    protected Map<String, Object> toJsonMap(IAccessEvent event) {
        return new MapBuilder(this.timestampFormatter, this.customFieldNames, this.additionalFields, 20).add("port", this.isIncluded(AccessAttribute.LOCAL_PORT), event.getLocalPort()).add("contentLength", this.isIncluded(AccessAttribute.CONTENT_LENGTH), event.getContentLength()).addTimestamp("timestamp", this.isIncluded(AccessAttribute.TIMESTAMP), event.getTimeStamp()).add("method", this.isIncluded(AccessAttribute.METHOD), event.getMethod()).add("protocol", this.isIncluded(AccessAttribute.PROTOCOL), event.getProtocol()).add("requestContent", this.isIncluded(AccessAttribute.REQUEST_CONTENT), event.getRequestContent()).add("remoteAddress", this.isIncluded(AccessAttribute.REMOTE_ADDRESS), event.getRemoteAddr()).add("remoteUser", this.isIncluded(AccessAttribute.REMOTE_USER), event.getRemoteUser()).add("headers", !this.requestHeaders.isEmpty(), this.filterHeaders(event.getRequestHeaderMap(), (Set<String>)this.requestHeaders)).add("params", this.isIncluded(AccessAttribute.REQUEST_PARAMETERS), event.getRequestParameterMap()).add("requestTime", this.isIncluded(AccessAttribute.REQUEST_TIME), event.getElapsedTime()).add("uri", this.isIncluded(AccessAttribute.REQUEST_URI), event.getRequestURI()).add("url", this.isIncluded(AccessAttribute.REQUEST_URL), event.getRequestURL()).add("remoteHost", this.isIncluded(AccessAttribute.REMOTE_HOST), event.getRemoteHost()).add("responseContent", this.isIncluded(AccessAttribute.RESPONSE_CONTENT), event.getResponseContent()).add("responseHeaders", !this.responseHeaders.isEmpty(), this.filterHeaders(event.getResponseHeaderMap(), (Set<String>)this.responseHeaders)).add("serverName", this.isIncluded(AccessAttribute.SERVER_NAME), event.getServerName()).add("status", this.isIncluded(AccessAttribute.STATUS_CODE), event.getStatusCode()).add("userAgent", this.isIncluded(AccessAttribute.USER_AGENT), event.getRequestHeader("User-Agent")).add("version", this.jsonProtocolVersion != null, this.jsonProtocolVersion).build();
    }

    private boolean isIncluded(AccessAttribute userAgent) {
        return this.includes.contains((Object)userAgent);
    }

    private Map<String, String> filterHeaders(Map<String, String> headers, Set<String> filteredHeaderNames) {
        if (filteredHeaderNames.isEmpty()) {
            return ImmutableMap.of();
        }
        return headers.entrySet().stream().filter(e -> filteredHeaderNames.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ImmutableSet<AccessAttribute> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<AccessAttribute> includes) {
        this.includes = Sets.immutableEnumSet(includes);
    }

    @Nullable
    public String getJsonProtocolVersion() {
        return this.jsonProtocolVersion;
    }

    public void setJsonProtocolVersion(@Nullable String jsonProtocolVersion) {
        this.jsonProtocolVersion = jsonProtocolVersion;
    }

    public ImmutableSet<String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Set<String> requestHeaders) {
        this.requestHeaders = ImmutableSortedSet.copyOf(String::compareToIgnoreCase, requestHeaders);
    }

    public ImmutableSet<String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Set<String> responseHeaders) {
        this.responseHeaders = ImmutableSortedSet.copyOf(String::compareToIgnoreCase, responseHeaders);
    }
}

