/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.logging.json.AbstractJsonLayoutBaseFactory;
import io.dropwizard.logging.json.EventAttribute;
import io.dropwizard.logging.json.layout.EventJsonLayout;
import java.util.EnumSet;
import java.util.Set;
import java.util.TimeZone;

@JsonTypeName(value="json")
public class EventJsonLayoutBaseFactory
extends AbstractJsonLayoutBaseFactory<ILoggingEvent> {
    private EnumSet<EventAttribute> includes = EnumSet.of(EventAttribute.LEVEL, new EventAttribute[]{EventAttribute.THREAD_NAME, EventAttribute.MDC, EventAttribute.MARKER, EventAttribute.LOGGER_NAME, EventAttribute.MESSAGE, EventAttribute.EXCEPTION, EventAttribute.TIMESTAMP});
    private Set<String> includesMdcKeys = ImmutableSet.of();
    private boolean flattenMdc = false;

    @JsonProperty
    public EnumSet<EventAttribute> getIncludes() {
        return this.includes;
    }

    @JsonProperty
    public void setIncludes(EnumSet<EventAttribute> includes) {
        this.includes = includes;
    }

    @JsonProperty
    public Set<String> getIncludesMdcKeys() {
        return this.includesMdcKeys;
    }

    @JsonProperty
    public void setIncludesMdcKeys(Set<String> includesMdcKeys) {
        this.includesMdcKeys = includesMdcKeys;
    }

    @JsonProperty
    public boolean isFlattenMdc() {
        return this.flattenMdc;
    }

    @JsonProperty
    public void setFlattenMdc(boolean flattenMdc) {
        this.flattenMdc = flattenMdc;
    }

    public LayoutBase<ILoggingEvent> build(LoggerContext context, TimeZone timeZone) {
        EventJsonLayout jsonLayout = new EventJsonLayout(this.createDropwizardJsonFormatter(), this.createTimestampFormatter(timeZone), this.createThrowableProxyConverter(), this.includes, this.getCustomFieldNames(), this.getAdditionalFields(), this.includesMdcKeys, this.flattenMdc);
        jsonLayout.setContext((Context)context);
        return jsonLayout;
    }

    protected ThrowableHandlingConverter createThrowableProxyConverter() {
        return new RootCauseFirstThrowableProxyConverter();
    }
}

