/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import io.dropwizard.util.Throwables;
import java.io.EOFException;
import java.util.zip.ZipException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

class ZipExceptionHandlingRequestWrapper
extends Request.Wrapper {
    private @Nullable Throwable gzipException = null;
    private final Response response;

    public ZipExceptionHandlingRequestWrapper(Request wrapped, Response response) {
        super(wrapped);
        this.response = response;
    }

    public void fail(Throwable failure) {
        Throwables.findThrowableInChain(t -> t.getCause() == null && (t instanceof ZipException || t instanceof EOFException), (Throwable)failure).ifPresent(throwable -> {
            this.gzipException = throwable;
            this.response.setStatus(400);
        });
        super.fail(failure);
    }

    public @Nullable Throwable getGzipException() {
        return this.gzipException;
    }
}

