/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.hibernate5.jakarta.Hibernate5JakartaModule;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.hibernate.SessionFactoryHealthCheck;
import io.dropwizard.hibernate.UnitOfWorkApplicationListener;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public abstract class HibernateBundle<T>
implements ConfiguredBundle<T>,
DatabaseConfiguration<T> {
    public static final String DEFAULT_NAME = "hibernate";
    protected @Nullable SessionFactory sessionFactory;
    protected boolean lazyLoadingEnabled = true;
    protected final List<Class<?>> entities;
    protected final SessionFactoryFactory sessionFactoryFactory;

    protected HibernateBundle(Class<?> entity, Class<?> ... entities) {
        ArrayList entityClasses = new ArrayList();
        entityClasses.add(entity);
        entityClasses.addAll(Arrays.asList(entities));
        this.entities = Collections.unmodifiableList(entityClasses);
        this.sessionFactoryFactory = new SessionFactoryFactory();
    }

    protected HibernateBundle(List<Class<?>> entities, SessionFactoryFactory sessionFactoryFactory) {
        this.entities = entities;
        this.sessionFactoryFactory = sessionFactoryFactory;
    }

    public final void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)this.createHibernate5Module());
    }

    protected Hibernate5JakartaModule createHibernate5Module() {
        Hibernate5JakartaModule module = new Hibernate5JakartaModule();
        if (this.lazyLoadingEnabled) {
            module.enable(Hibernate5JakartaModule.Feature.FORCE_LAZY_LOADING);
        }
        return module;
    }

    protected String name() {
        return DEFAULT_NAME;
    }

    public void run(T configuration, Environment environment) throws Exception {
        PooledDataSourceFactory dbConfig = this.getDataSourceFactory(configuration);
        this.sessionFactory = Objects.requireNonNull(this.sessionFactoryFactory.build(this, environment, dbConfig, this.entities, this.name()));
        this.registerUnitOfWorkListenerIfAbsent(environment).registerSessionFactory(this.name(), this.sessionFactory);
        environment.healthChecks().register(this.name(), (HealthCheck)new SessionFactoryHealthCheck(environment.getHealthCheckExecutorService(), dbConfig.getValidationQueryTimeout().orElse(Duration.seconds((long)5L)), this.sessionFactory, dbConfig.getValidationQuery()));
    }

    protected UnitOfWorkApplicationListener registerUnitOfWorkListenerIfAbsent(Environment environment) {
        for (Object singleton : environment.jersey().getResourceConfig().getSingletons()) {
            if (!(singleton instanceof UnitOfWorkApplicationListener)) continue;
            return (UnitOfWorkApplicationListener)singleton;
        }
        UnitOfWorkApplicationListener listener = new UnitOfWorkApplicationListener();
        environment.jersey().register((Object)listener);
        return listener;
    }

    public boolean isLazyLoadingEnabled() {
        return this.lazyLoadingEnabled;
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.lazyLoadingEnabled = lazyLoadingEnabled;
    }

    public SessionFactory getSessionFactory() {
        return Objects.requireNonNull(this.sessionFactory);
    }

    protected void configure(Configuration configuration) {
    }
}

