/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate.dual;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Metamodel;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;

public class DualSessionFactory
implements SessionFactory {
    private static final long serialVersionUID = 1L;
    private final SessionFactory primary;
    private final SessionFactory reader;
    private final ThreadLocal<SessionFactory> current = new ThreadLocal();

    public DualSessionFactory(SessionFactory primary, SessionFactory reader) {
        this.primary = primary;
        this.reader = reader;
        this.current.set(primary);
    }

    public SessionFactory prepare(boolean readOnly) {
        SessionFactory factory = readOnly ? this.reader : this.primary;
        this.current.set(factory);
        return factory;
    }

    public SessionFactory current() {
        return this.current.get();
    }

    public EntityManager createEntityManager() {
        return this.current().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.current().createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.current().createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.current().createEntityManager(synchronizationType, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.current().getCriteriaBuilder();
    }

    public boolean isOpen() {
        return this.current().isOpen();
    }

    public Map<String, Object> getProperties() {
        return this.current().getProperties();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.current().getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.current().addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.current().unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.current().addNamedEntityGraph(graphName, entityGraph);
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.current().findEntityGraphsByType(entityClass);
    }

    public Metamodel getMetamodel() {
        return this.current().getMetamodel();
    }

    public Reference getReference() throws NamingException {
        return this.current().getReference();
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.current().getSessionFactoryOptions();
    }

    public SessionBuilder withOptions() {
        return this.current().withOptions();
    }

    public Session openSession() throws HibernateException {
        return this.current().openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return this.current().getCurrentSession();
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.current().withStatelessOptions();
    }

    public StatelessSession openStatelessSession() {
        return this.current().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.current().openStatelessSession(connection);
    }

    public Statistics getStatistics() {
        return this.current().getStatistics();
    }

    public void close() throws HibernateException {
        this.current().close();
    }

    public boolean isClosed() {
        return this.current().isClosed();
    }

    public Cache getCache() {
        return this.current().getCache();
    }

    public Set getDefinedFilterNames() {
        return this.current().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.current().getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.current().containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return this.current().getTypeHelper();
    }

    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.current().getClassMetadata(entityClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.current().getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.current().getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() {
        return this.current().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.current().getAllCollectionMetadata();
    }
}

