/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate.dual;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.hibernate.SessionFactoryHealthCheck;
import io.dropwizard.hibernate.dual.DualSessionFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.hibernate.SessionFactory;

public abstract class HibernateBundle<T>
extends io.dropwizard.hibernate.HibernateBundle<T> {
    public static final String PRIMARY = ":hibernate-primary";
    public static final String READER = ":hibernate-reader";

    protected HibernateBundle(Class<?> entity, Class<?> ... entities) {
        super(entity, entities);
    }

    protected HibernateBundle(List<Class<?>> entities, SessionFactoryFactory sessionFactoryFactory) {
        super(entities, sessionFactoryFactory);
    }

    public abstract PooledDataSourceFactory getReadSourceFactory(T var1);

    @Override
    public void run(T configuration, Environment environment) throws Exception {
        String name = this.name();
        String primaryName = name + PRIMARY;
        String readerName = name + READER;
        PooledDataSourceFactory primaryConfig = this.getDataSourceFactory(configuration);
        SessionFactory primary = Objects.requireNonNull(this.sessionFactoryFactory.build(this, environment, primaryConfig, this.entities, primaryName));
        PooledDataSourceFactory readerConfig = this.getReadSourceFactory(configuration);
        SessionFactory reader = Objects.requireNonNull(this.sessionFactoryFactory.build(this, environment, readerConfig, this.entities, readerName));
        DualSessionFactory factory = new DualSessionFactory(primary, reader);
        this.registerUnitOfWorkListenerIfAbsent(environment).registerSessionFactory(name, factory);
        ExecutorService exec = environment.getHealthCheckExecutorService();
        environment.healthChecks().register(primaryName, (HealthCheck)new SessionFactoryHealthCheck(exec, primaryConfig.getValidationQueryTimeout().orElse(Duration.seconds((long)5L)), primary, primaryConfig.getValidationQuery()));
        environment.healthChecks().register(readerName, (HealthCheck)new SessionFactoryHealthCheck(exec, readerConfig.getValidationQueryTimeout().orElse(Duration.seconds((long)5L)), reader, readerConfig.getValidationQuery()));
        this.sessionFactory = factory;
    }
}

