/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.google.common.collect.ImmutableMap;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.UnitOfWork;
import io.dropwizard.hibernate.UnitOfWorkAspect;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.SessionFactory;

public class UnitOfWorkAwareProxyFactory {
    private final ImmutableMap<String, SessionFactory> sessionFactories;

    public UnitOfWorkAwareProxyFactory(String name, SessionFactory sessionFactory) {
        this.sessionFactories = ImmutableMap.of((Object)name, (Object)sessionFactory);
    }

    public UnitOfWorkAwareProxyFactory(HibernateBundle<?> ... bundles) {
        ImmutableMap.Builder sessionFactoriesBuilder = ImmutableMap.builder();
        for (HibernateBundle<?> bundle : bundles) {
            sessionFactoriesBuilder.put((Object)bundle.name(), (Object)bundle.getSessionFactory());
        }
        this.sessionFactories = sessionFactoriesBuilder.build();
    }

    public <T> T create(Class<T> clazz) {
        return this.create(clazz, new Class[0], new Object[0]);
    }

    public <T> T create(Class<T> clazz, Class<?> constructorParamType, Object constructorArguments) {
        return this.create(clazz, new Class[]{constructorParamType}, new Object[]{constructorArguments});
    }

    public <T> T create(Class<T> clazz, Class<?>[] constructorParamTypes, Object[] constructorArguments) {
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(clazz);
        try {
            Proxy proxy = (Proxy)(constructorParamTypes.length == 0 ? factory.createClass().getConstructor(new Class[0]).newInstance(new Object[0]) : factory.create((Class[])constructorParamTypes, constructorArguments));
            proxy.setHandler((self, overridden, proceed, args) -> {
                UnitOfWork unitOfWork = overridden.getAnnotation(UnitOfWork.class);
                UnitOfWorkAspect unitOfWorkAspect = this.newAspect(this.sessionFactories);
                try {
                    unitOfWorkAspect.beforeStart(unitOfWork);
                    Object result = proceed.invoke(self, args);
                    unitOfWorkAspect.afterEnd();
                    Object object = result;
                    return object;
                }
                catch (InvocationTargetException e) {
                    unitOfWorkAspect.onError();
                    throw e.getCause();
                }
                catch (Exception e) {
                    unitOfWorkAspect.onError();
                    throw e;
                }
                finally {
                    unitOfWorkAspect.onFinish();
                }
            });
            return (T)proxy;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create a proxy for the class '" + clazz + "'", e);
        }
    }

    public UnitOfWorkAspect newAspect() {
        return new UnitOfWorkAspect((Map<String, SessionFactory>)this.sessionFactories);
    }

    public UnitOfWorkAspect newAspect(ImmutableMap<String, SessionFactory> sessionFactories) {
        return new UnitOfWorkAspect((Map<String, SessionFactory>)sessionFactories);
    }
}

