/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.WebApplicationExceptionCatchingFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class PolymorphicAuthDynamicFeature<T extends Principal>
implements DynamicFeature {
    private final Map<Class<? extends T>, ContainerRequestFilter> authFilterMap;

    public PolymorphicAuthDynamicFeature(Map<Class<? extends T>, ContainerRequestFilter> authFilterMap) {
        this.authFilterMap = authFilterMap;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Annotation[][] parameterAnnotations = am.getParameterAnnotations();
        Class[] parameterTypes = am.getParameterTypes();
        Type[] parameterGenericTypes = am.getGenericParameterTypes();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Class type = parameterTypes[i];
            Class paramType = type == Optional.class ? ((ParameterizedType)parameterGenericTypes[i]).getActualTypeArguments()[0] : type;
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof Auth) || !this.authFilterMap.containsKey(paramType)) continue;
                if (type == Optional.class) {
                    ContainerRequestFilter filter = this.authFilterMap.get(paramType);
                    context.register((Object)new WebApplicationExceptionCatchingFilter(filter));
                    return;
                }
                context.register((Object)this.authFilterMap.get(type));
                return;
            }
        }
    }
}

