/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import java.lang.annotation.Annotation;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class AuthDynamicFeature
implements DynamicFeature {
    private final ContainerRequestFilter authFilter;

    public AuthDynamicFeature(ContainerRequestFilter authFilter) {
        this.authFilter = authFilter;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        boolean annotationOnMethod;
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Annotation[][] parameterAnnotations = am.getParameterAnnotations();
        boolean annotationOnClass = resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class) != null || resourceInfo.getResourceClass().getAnnotation(PermitAll.class) != null;
        boolean bl = annotationOnMethod = am.isAnnotationPresent(RolesAllowed.class) || am.isAnnotationPresent(DenyAll.class) || am.isAnnotationPresent(PermitAll.class);
        if (annotationOnClass || annotationOnMethod) {
            context.register((Object)this.authFilter);
        } else {
            Annotation[][] annotationArray = parameterAnnotations;
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!(annotation instanceof Auth)) continue;
                    context.register((Object)this.authFilter);
                    return;
                }
            }
        }
    }
}

