/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunHookFinished;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.prettyformatter.Theme;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class ProgressWriter
implements AutoCloseable {
    private final PrintWriter writer;
    private final Theme theme;
    private final int maxWidth;
    private int width = 0;

    ProgressWriter(OutputStream out, Theme theme, int maxWidth) {
        this.writer = ProgressWriter.createPrintWriter(out);
        this.theme = Objects.requireNonNull(theme);
        this.maxWidth = maxWidth;
    }

    private static PrintWriter createPrintWriter(OutputStream out) {
        return new PrintWriter((Writer)new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8), true);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    void write(TestRunHookFinished event) {
        this.printStatus(event.getResult().getStatus());
    }

    void write(TestStepFinished event) {
        this.printStatus(event.getTestStepResult().getStatus());
    }

    private void printStatus(TestStepResultStatus status) {
        StringBuilder buffer = new StringBuilder();
        String icon = this.theme.progressIcon(status);
        buffer.append(this.theme.style(Theme.Element.PROGRESS_ICON, status, icon));
        if (++this.width % this.maxWidth == 0) {
            this.width = 0;
            buffer.append(System.lineSeparator());
        }
        this.writer.append(buffer);
        this.writer.flush();
    }

    void write(TestRunFinished testRunHookFinished) {
        this.writer.println();
    }
}

