/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Envelope;
import io.cucumber.prettyformatter.ProgressWriter;
import io.cucumber.prettyformatter.Theme;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public final class MessagesToProgressWriter
implements AutoCloseable {
    private final ProgressWriter writer;
    private boolean streamClosed = false;

    private MessagesToProgressWriter(OutputStream out, Theme theme, int maxWidth) {
        this.writer = new ProgressWriter(out, theme, maxWidth);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        envelope.getTestRunHookFinished().ifPresent(this.writer::write);
        envelope.getTestStepFinished().ifPresent(this.writer::write);
        envelope.getTestRunFinished().ifPresent(this.writer::write);
    }

    @Override
    public void close() {
        if (this.streamClosed) {
            return;
        }
        try {
            this.writer.close();
        }
        finally {
            this.streamClosed = true;
        }
    }

    public static final class Builder {
        private static final int DEFAULT_MAX_WIDTH = 80;
        private Theme theme = Theme.plain();
        private int maxWidth = 80;

        private Builder() {
        }

        public Builder theme(Theme theme) {
            this.theme = Objects.requireNonNull(theme);
            return this;
        }

        public Builder maxWidth(int maxWidth) {
            if (maxWidth <= 0) {
                throw new IllegalArgumentException("maxWidth must be a positive non-zero value");
            }
            this.maxWidth = maxWidth;
            return this;
        }

        public MessagesToProgressWriter build(OutputStream out) {
            Objects.requireNonNull(out);
            return new MessagesToProgressWriter(out, this.theme, this.maxWidth);
        }
    }
}

