/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.prettyformatter.Theme;
import java.util.function.Consumer;

final class LineBuilder {
    private final StringBuilder builder = new StringBuilder(80);
    private final Theme theme;
    private int unstyledLength;

    LineBuilder(Theme theme) {
        this.theme = theme;
    }

    LineBuilder indent(int indent) {
        return this.append(this.createPadding(indent));
    }

    LineBuilder title(Theme.Element keywordElement, String keyword, Theme.Element nameElement, String name) {
        return this.append(keywordElement, keyword + ":").append(" ").append(nameElement, name);
    }

    LineBuilder statusIcon(String statusIcon) {
        ++this.unstyledLength;
        this.builder.append(statusIcon);
        return this;
    }

    LineBuilder addPaddingUpTo(int index) {
        return this.append(this.createPadding(index));
    }

    private String createPadding(int commentStartAtIndex) {
        int padding = commentStartAtIndex - this.unstyledLength;
        StringBuilder builder = new StringBuilder(padding);
        for (int i = 0; i < padding; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    LineBuilder accept(Consumer<LineBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    LineBuilder newLine() {
        this.unstyledLength = 0;
        this.builder.append(System.lineSeparator());
        return this;
    }

    LineBuilder append(String text) {
        this.unstyledLength += text.length();
        this.builder.append(text);
        return this;
    }

    LineBuilder append(Theme.Element element, String text) {
        this.unstyledLength += text.length();
        this.builder.append(this.theme.style(element, text));
        return this;
    }

    LineBuilder begin(Theme.Element element) {
        this.builder.append(this.theme.beginStyle(element));
        return this;
    }

    LineBuilder begin(Theme.Element element, TestStepResultStatus status) {
        this.builder.append(this.theme.beginStyle(element, status));
        return this;
    }

    LineBuilder end(Theme.Element element) {
        this.builder.append(this.theme.endStyle(element));
        return this;
    }

    LineBuilder end(Theme.Element element, TestStepResultStatus status) {
        this.builder.append(this.theme.endStyle(element, status));
        return this;
    }

    String build() {
        return this.builder.toString();
    }

    public String toString() {
        return this.builder.toString();
    }
}

