/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.internal.com.google.protobuf;

import io.cucumber.messages.internal.com.google.protobuf.GeneratedMessageLite;
import io.cucumber.messages.internal.com.google.protobuf.MessageInfo;
import io.cucumber.messages.internal.com.google.protobuf.MessageInfoFactory;

class GeneratedMessageInfoFactory
implements MessageInfoFactory {
    private static final GeneratedMessageInfoFactory instance = new GeneratedMessageInfoFactory();

    private GeneratedMessageInfoFactory() {
    }

    public static GeneratedMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public boolean isSupported(Class<?> messageType) {
        return GeneratedMessageLite.class.isAssignableFrom(messageType);
    }

    @Override
    public MessageInfo messageInfoFor(Class<?> messageType) {
        if (!GeneratedMessageLite.class.isAssignableFrom(messageType)) {
            throw new IllegalArgumentException("Unsupported message type: " + messageType.getName());
        }
        try {
            return (MessageInfo)GeneratedMessageLite.getDefaultInstance(messageType.asSubclass(GeneratedMessageLite.class)).buildMessageInfo();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get message info for " + messageType.getName(), e);
        }
    }
}

